/*********************************
*                                *
*   powerpacker.library  V36     *
*                                *
*   Release 1.6                  *
*                                *
*   (c) 1991-1993 Nico Franois  *
*                                *
*   example.c                    *
*                                *
*   This source is public domain *
*   in all respects.             *
*                                *
*********************************/

#include <exec/types.h>
#include <exec/memory.h>
#include <libraries/dos.h>
#include <proto/exec.h>
#include <proto/dos.h>

#include <stdio.h>

#include <proto/powerpacker.h>
#include <libraries/ppbase.h>

struct PPBase *PPBase = NULL;

UBYTE *filestart = NULL;
ULONG filelen;

char file[108] = "testfile";

main()
{
   int err;

   if (!(PPBase = (struct PPBase *)OpenLibrary ("powerpacker.library", 0L)))

      puts ("You need powerpacker.library V33+ !");

   else {

      puts ("Loading file...");

      err = ppLoadData (file, DECR_POINTER, 0L, &filestart, &filelen, NULL);
      if (err)
			printf ("example: %s!\n", ppErrorMessage (err));

      else {

         puts ("file in memory, using it...");

         /* file is loaded at 'filestart' and can now be used */

         /* ... */

         puts ("done, freeing file...");

         }

      }

   /* free all resources */

   if (filestart) FreeMem (filestart, filelen);

   if (PPBase) CloseLibrary ((struct Library *)PPBase);

   puts ("exiting.");

   exit (0);
}
