\ THREADS.4TH  -  Thread creation under Forth/2   04/22/93
\ Copyright (c) 1993  BLUE STAR SYSTEMS
\
\ These are some preliminary words to run threads under Forth/2 using
\ the OS/2 function CreateThread.  Any output they do shows up in the 
\ Forth/2 screen, but the output is harmless.
\
\ You can THREAD just about any word which operates independently and
\ does not require any stack parameters.

decimal

variable ThreadInfo   \ Information to be passed to thread, USER area
       4 allot        \   and execution address of thread

variable ThreadID
variable ThreadArg              \ Allot parameter space after this
8192 constant ThreadStackSize

: usleep ( msec    -- )  SYS$SLEEP SYSCALL 2drop ;  \ Put thread to sleep
: sleep  ( seconds -- )  1000 * usleep ;


: StartThread ( tick_addr -- ) CFA @  ThreadInfo CELL+ !  'USER @ ThreadInfo !
              ThreadInfo ThreadArg !
              ThreadStackSize
              0                \ Flags: 0=Start now, 1=Start suspended
              ThreadArg
          ['] ThreadProc CFA @
              ThreadID           SYS$CREATETHREAD SYSCALL
              6 DROPS ;


: KillThread  ( pid -- )  SYS$KillThread SYSCALL 2drop ;

\ THREAD   Usage:  THREAD <name>  starts <name> running as a separate thread

: THREAD   State @ IF  POSTPONE [']  POSTPONE StartThread
                 ELSE  '  StartThread  THEN ;  IMMEDIATE


\ Examples

: Bunny            5 sleep ." It keeps going, and going..."
           50 0 do 2 sleep cr   ." and going, and going..."
                   loop ;

variable TimeLength
: Timer ( -- )      TimeLength @ sleep  ." It's time! " ;
: Alarm ( secs -- ) TimeLength !  THREAD Timer ;

\ Try  THREAD bunny    or  10 Alarm    Do a bunch of them!

