{*
*
*   Copyright (c) 1992 by Richard W. Hansen
*
*   This source code will compile.
*   Unpacked source is available to registered users.
*
*}
Unit TvScroll;INTERFACE {$I TVDEFS.INC}USES {$IFDEF TVSCROLL}TvConst,{$ENDIF}Objects,Dialogs,Drivers,Views;{$IFNDEF TVSCROLL}
CONST gfGrowXYRel=$80;cmDragView=3000;{$ENDIF}TYPE PScrollView=^TScrollView;TScrollView=Object(TView)
Constructor Init(var Bounds:TRect);Procedure HandleEvent(var Event:TEvent);Virtual;
Procedure SetState(AState:Word;Enable:Boolean);Virtual;end;PScrollInputLine=^TScrollInputLine;
TScrollInputLine=Object(TInputLine)Constructor Init(var Bounds:TRect;AMaxLen:Integer);Function GetPalette:PPalette;Virtual;
end;PScrollGroup=^TScrollGroup;TScrollGroup=Object(TGroup)VScrollBar:PScrollBar;HScrollBar:PScrollBar;OldPos:TPoint;
Constructor Init(var Bounds:TRect;AHScrollBar:PScrollBar;AVScrollBar:PScrollBar);
Procedure HandleEvent(var Event:TEvent);Virtual;end;PScrollWindow=^TScrollWindow;TScrollWindow=Object(TWindow)Limit:TPoint;
VScrollBar:PScrollBar;HScrollBar:PScrollBar;Interior:PScrollGroup;
Constructor Init(var Bounds:TRect;ATitle:String;ANumber:Word);Procedure SetLimit(X,Y:Integer);
Procedure InsertToScroll(P:PView);Procedure SizeLimits(var Min,Max:TPoint);Virtual;
Procedure ChangeBounds(var Bounds:TRect);Virtual;end;PScrollDialog=^TScrollDialog;TScrollDialog=Object(TDialog)Limit:TPoint;
VScrollBar:PScrollBar;HScrollBar:PScrollBar;Interior:PScrollGroup;Constructor Init(var Bounds:TRect;ATitle:String);
Procedure SetLimit(X,Y:Integer);Procedure InsertToScroll(P:PView);Procedure SizeLimits(var Min,Max:TPoint);Virtual;
Procedure ChangeBounds(var Bounds:TRect);Virtual;end;IMPLEMENTATION Constructor TScrollView.Init(var Bounds:TRect);begin
TView.Init(Bounds);Options:=Options OR ofSelectable;DragMode:=dmDragMove OR dmDragGrow;GrowMode:=GrowMode OR gfGrowXYRel;
EventMask:=EventMask OR evBroadcast;end;Procedure TScrollView.SetState(AState:Word;Enable:Boolean);begin
TView.SetState(AState,Enable);if(AState=sfSelected)then SetState(sfActive,Enable)
else if(AState AND(sfDragging OR sfActive)<>0)then DrawView;end;Procedure TScrollView.HandleEvent(var Event:TEvent);
Procedure Drag(Mode:Byte);var Limits:TRect;Min,Max:TPoint;begin if(DragMode and Mode<>0)then begin Owner^.GetExtent(Limits);
SizeLimits(Min,Max);Mode:=Mode OR DragMode AND not dmDragMove AND not dmDragGrow;DragView(Event,Mode,Limits,Min,Max);
ClearEvent(Event);end;end;var Mouse:TPoint;begin TView.HandleEvent(Event);if(Event.What=evCommand)then begin
Case Event.Command of cmDragView:Drag(dmDragMove OR dmDragGrow);end;end else if(Event.What=evBroadcast)then begin
Case Event.Command of cmReceivedFocus,cmReleasedFocus:DrawView;end;end else if(Event.What=evMouseDown)then begin
MakeLocal(Event.Where,Mouse);if(Mouse.Y=0)and(Mouse.X<Size.X-1)then Drag(dmDragMove)
else if(Mouse.X>=Size.X-1)and(Mouse.Y>=Size.Y-1)then Drag(dmDragGrow);end;end;
Constructor TScrollInputLine.Init(var Bounds:TRect;AMaxLen:Integer);begin TInputLine.Init(Bounds,AMaxLen);
GrowMode:=GrowMode OR gfGrowXYRel;end;Function TScrollInputLine.GetPalette:PPalette;const CScrollInputLine=#1#6#7#1;
PScrollInputLine:String[Length(CScrollInputLine)]=CScrollInputLine;begin GetPalette:=@PScrollInputLine;end;
Constructor TScrollGroup.Init(var Bounds:TRect;AHScrollBar:PScrollBar;AVScrollBar:PScrollBar);begin TGroup.Init(Bounds);
HScrollBar:=AHScrollBar;VScrollBar:=AVScrollBar;GrowMode:=GrowMode OR gfGrowHiX OR gfGrowHiY;end;
Procedure TScrollGroup.HandleEvent(var Event:TEvent);var X:Integer;Y:Integer;Procedure Adjust(P:PScrollView);FAR;begin 
if(P^.GrowMode AND gfGrowXYRel<>0)then begin P^.Origin.X:=P^.Origin.X+X;P^.Origin.Y:=P^.Origin.Y+Y;end;end;begin
TGroup.HandleEvent(Event);if(Event.What=evBroadcast)then Case Event.Command of cmScrollBarChanged:begin
if(HScrollBar<>nil)then begin X:=OldPos.X-HScrollBar^.Value;OldPos.X:=HScrollBar^.Value;end else begin X:=0;end;
if(VScrollBar<>nil)then begin Y:=OldPos.Y-VScrollBar^.Value;OldPos.Y:=VScrollBar^.Value;end else begin Y:=0;end;
ForEach(@Adjust);Redraw;EXIT;end;end else if(Event.What=evKeyDown)then Case Event.KeyCode of kbTab:begin SelectNext(False);
ClearEvent(Event);end;kbShiftTab:begin SelectNext(True);ClearEvent(Event);end;end;end;
Constructor TScrollWindow.Init(var Bounds:TRect;ATitle:String;ANumber:Word);var R:TRect;begin
TWindow.Init(Bounds,ATitle,ANumber);HScrollBar:=StandardScrollBar(sbHorizontal OR sbHandleKeyboard);Insert(HScrollBar);
VScrollBar:=StandardScrollBar(sbVertical OR sbHandleKeyboard);Insert(VScrollBar);GetExtent(R);R.Grow(-1,-1);
Interior:=New(PScrollGroup,Init(R,HScrollBar,VScrollBar));Insert(Interior);end;Procedure TScrollWindow.SetLimit(X,Y:Integer);
begin Limit.X:=X;Limit.Y:=Y;if HScrollBar<>nil then HScrollBar^.SetParams(HScrollBar^.Value,0,X-Size.X,Size.X-1,1);
if VScrollBar<>nil then VScrollBar^.SetParams(VScrollBar^.Value,0,Y-Size.Y,Size.Y-1,1);end;
Procedure TScrollWindow.InsertToScroll(P:PView);begin Interior^.Insert(P);end;
Procedure TScrollWindow.SizeLimits(var Min,Max:TPoint);begin TWindow.SizeLimits(Min,Max);Max.X:=Limit.X;Max.Y:=Limit.Y;
if HScrollBar<>nil then Max.X:=Max.X-HScrollBar^.Value;if VScrollBar<>nil then Max.Y:=Max.Y-VScrollBar^.Value;end;
Procedure TScrollWindow.ChangeBounds(var Bounds:TRect);begin TWindow.ChangeBounds(Bounds);if HScrollBar<>nil then
HScrollBar^.SetParams(HScrollBar^.Value,0,Limit.X-Size.X+2,Size.X-1,1);if VScrollBar<>nil then
VScrollBar^.SetParams(VScrollBar^.Value,0,Limit.Y-Size.Y+2,Size.Y-1,1);end;
Constructor TScrollDialog.Init(var Bounds:TRect;ATitle:String);var R:TRect;begin TDialog.Init(Bounds,ATitle);
HScrollBar:=StandardScrollBar(sbHorizontal OR sbHandleKeyboard);Insert(HScrollBar);
VScrollBar:=StandardScrollBar(sbVertical OR sbHandleKeyboard);Insert(VScrollBar);GetExtent(R);R.Grow(-1,-1);
Interior:=New(PScrollGroup,Init(R,HScrollBar,VScrollBar));Insert(Interior);end;Procedure TScrollDialog.SetLimit(X,Y:Integer);
begin Limit.X:=X;Limit.Y:=Y;if HScrollBar<>nil then HScrollBar^.SetParams(HScrollBar^.Value,0,X-Size.X,Size.X-1,1);
if VScrollBar<>nil then VScrollBar^.SetParams(VScrollBar^.Value,0,Y-Size.Y,Size.Y-1,1);end;
Procedure TScrollDialog.InsertToScroll(P:PView);begin Interior^.Insert(P);end;
Procedure TScrollDialog.SizeLimits(var Min,Max:TPoint);begin TDialog.SizeLimits(Min,Max);Max.X:=Limit.X;Max.Y:=Limit.Y;
if HScrollBar<>nil then Max.X:=Max.X-HScrollBar^.Value;if VScrollBar<>nil then Max.Y:=Max.Y-VScrollBar^.Value;end;
Procedure TScrollDialog.ChangeBounds(var Bounds:TRect);begin TDialog.ChangeBounds(Bounds);if HScrollBar<>nil then
HScrollBar^.SetParams(HScrollBar^.Value,0,Limit.X-Size.X+2,Size.X-1,1);if VScrollBar<>nil then
VScrollBar^.SetParams(VScrollBar^.Value,0,Limit.Y-Size.Y+2,Size.Y-1,1);end;END.
