{$I compiler }
UNIT General;INTERFACE USES Dos,Crt,Overlay,                     { TP }
                            ExecProc,                        { SHAZAM }
                            Drivers,Memory,HistList,        { RunTime }
                            Objects,Views,Menus,Dialogs,    { RunTime }
                            ColorSel,App,MsgBox,StdDlg,     { Example }
                            HelpFile,                       { Example }
                            Buffers,Editors;                { Example }
   {*******************************************************************
   GENERAL.PAS, Version 2.1    Copyright (c) 1991,92 Johnathan J. Stein
                                                    All Rights Reserved
                                                              WorldWide
   Only for use by Licensed Users of SHAZAM.

   STEIN RESEARCH & ENGINEERING                      Voice 419.666.7103
   Post Office Box 346                                 Fax 419.874.4922
   Perrysburg, OH  43552                           CompuServe 76576.470
   USA                                INTERNET 76576.470@compuserve.com
   *******************************************************************}
   {===================================================================

   PUBLIC/INTERFACE

   ===================================================================}
CONST
   MemoryWarning             : boolean = TRUE ;            { ExitProc }
   VersionCode               : string = '' ;
   AllowBorderColors         : boolean = TRUE ;

{$I gMisc.int }
{$I gString.int }
{$I gConvert.int }
{$I gUnsort.int }
{$I gDialog.int }
{$I gEditor.int }
{$I gDesktop.int }
{$I gVideo.int }
{$I gEvent.int }

procedure RegisterGeneral ;

IMPLEMENTATION
   {===================================================================

   PRIVATE/CODE

   ===================================================================}
{$I gMisc.imp }
{$I gString.imp }
{$I gConvert.imp }
{$I gUnsort.imp }
{$I gDialog.imp }
{$I gEditor.imp }
{$I gDesktop.imp }
{$I gVideo.imp }
{$I gEvent.imp }
   {===================================================================

   REGISTRATION

   ===================================================================}
procedure RegisterGeneral ;
begin
   RegisterType ( RSortedCollection ) ;
   RegisterType ( RUnsortedCollection ) ;
end ;
   {|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

   EXIT & ERROR

   |||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||}
VAR
   ExitSave                  : pointer ;
   {===================================================================

   HEAPFUNC - Causes New or GetMem to return NIL instead of abort.

   Normal Heap Error/Results:
   0 runtime error
   1 return NIL pointer
   2 success & retry

   ===================================================================}
function HeapFunc ( Size : word ) : integer ; FAR ;
begin
   HeapFunc                  := 1 ;
end ;
   {===================================================================

   EXIT - Clear border, detect undelete/undisposed objects.

   ===================================================================}
procedure ExitHandler ; FAR ;
begin
   ExitProc                  := ExitSave ;                   { normal }
   FreeScreen ;                                                { heap }
   NoSound ;                                                   { ears }
   SetBorder ( CRT.Black ) ;                                   { eyes }
   if not MemoryWarning then EXIT ;
   if ( HeapTrapped = 0 ) and
      ( HeapUsed = 0 ) then EXIT ;
   {- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
   REMIND - Forgot to free memory!
   - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -}
   Buzz ; Buzz ;
   PrintStr ( 'MEMORY NOT RELEASED!  ' +
              NumToStr ( HeapUsed ) + ' bytes used, ' +
              NumToStr ( HeapTrapped ) + ' bytes stuck' +
              #13#10 ) ;
end ;
   {===================================================================

   INSTALL

   ===================================================================}
procedure InstallExit ;
begin
   ExitSave                  := ExitProc ;
   ExitProc                  := @ExitHandler ;
   HeapError                 := @HeapFunc ;
end ;
   {^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
   INITIALIZATION
   ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^}
BEGIN
   InstallExit ;
END.

   General Purpose code for Turbo Vision.

   REGISTRATION VALUES - TStreamRec.ObjType [ 0..65,535 ]
   ------------------------------------------------------
            Range             Used   By
            -----             ----   --
           0..999            0..99   Turbo Vision
         500..600         500..511   DLGDSN & Dialog Editor
                          520..520   FormLine
      1000..65535                    Available range
                    10,000..10,099   Turbo Vision Examples
   60,000..65,535                    SHAZAM  
                    60,000..60,001   this unit
                    60,002..60,006   internal
                    65,535..65,535   generated "PNewStatusLine"


   COMMAND CONSTANTS - cmXXXX [ 0..65535 ]
   ---------------------------------------
            Range             Used   By
            -----             ----   --
            0..99                    Turbo Vision 
                            80..84   EDITORS
         100..255         100..255   Available (can disable)
         256..999                    Turbo Vision 
     1000..65,535                    Available (can NOT disable)
   60,000..65,535                    SHAZAM 
                    60,000..60,001   TPrint


   HELP CONTEXT - hcXXXX [ 0..65535 ]
   ----------------------------------
            Range             Used   By
            -----             ----   --
           0..999                    Turbo Vision
                              0..1   No context, View drag
      1000..65535                    Available
     60000..65535                    SHAZAM
