   UNIT:  EDITORS.PAS
PROBLEM:  Fatal hang when loading Desktop TEditWindows
   TEST:  Load Desktop file with 2+ TEditWindows, press PgDn = Fatal hang

Add the line marked with {!!}
-----------------------------
procedure TFileEditor.InitBuffer ;
begin
   NewBuffer ( Pointer ( Buffer ) ) ;
   BufSize                   := 0 ;             {!!}
end.
-----------------------------
From: Juergen Schlegelmilch <injs%dcztu1.bitnet@utcs.utoronto.ca>



------------------------------------------------------------
Delete or comment-out these lines; add "CanUndo := TRUE ;"
------------------------------------------------------------
TEditor.Store:
  { S.Write (CanUndo, SizeOf (Boolean)); }      { !! comment out }
  S.Write (AutoIndent, SizeOf (AutoIndent));    { !! add }
TEditor.Load:
  { S.Read (CanUndo, SizeOf (Boolean)); }       { !! comment out }
  S.Read (AutoIndent, SizeOf (AutoIndent));     { !! add }
  CanUndo                   := TRUE ;           { !! add }

------------------------------------------------------------
NOTES:

[X] "BufSize" messes up memory management by BUFFERS unit, when
    TFileEditor is used.  This is because the normal TEditor
    allocates memory directly from the heap, while TFileEditor
    replaces "InitBuffer" via a virtual method.

[X] "AutoIndent" should be saved.

[X] "CanUndo" is changed for two reasons:

    1.  If the ClipBoard is saved to a filename, "TEditor.Load"
        will load the file but with the UNDO disabled.

    2.  If your "Desktop Save" routine fails to ignore the
        ClipBoard, the resulting "Untitled" file will have its
        "CanUndo" set to FALSE, resulting in the same problem as
        number (1) above.

--------
COMMENTS
--------
Works properly for both TMemo and TFileEditor.  Already
implemented in Al Andersen's NEWEDIT.

///////////////////////////
//  Johnathan J. Stein   //
//  Post Office Box 346  // Comments or suggestions welcomed; please
// Perrysburg, OH  43552 // send to address(es) at left.
//    (419) 666-7103     //
// CompuServe 76576,470  //
///////////////////////////
