{$o+$A+}
{


   LZH.PAS - base unit for all Huffman engine components

   LZH.PAS based on:

   LZHUF.C English version 1.0 based on Japanese version 29-NOV-1988
   Haruhiko OKUMURA:   LZSS coded
   Haruyasu YOSHIZAKI: Adaptive Huffman Coding coded
   Kenji RIKITAKE:     Edited and translated to English
   Peter Sawatzki,
   Wayne Sullivan:     Converted to Turbo Pascal 5.0
   Joe Jared:          Assembler (12/16/92)
   Andres Cvitkovich:  object-oriented interface

   Your help is encouraged.


}
{$i-,v-,s-,f+,r-}
Unit LZH;
Interface
Const
     EngineVer = '0.19b';
type
    
  IObuf = array[0..$2800-1] of byte; {These buffers are now FIXED!}

  LZHRec = Record       {Segment:0 aligned}
         count          : LongInt;
         textsize       : LongInt;
         codesize       : LongInt;
         inptr,inend,outptr,outend    : Word;
         Ebytes         : Longint;
         inbuf,outbuf        : IObuf;
         {Buffersize and position are critical}
         WorkSpace           : Array [0..$86ff] of byte;
         {LZHASM work space} {Some space reserved}
         End;

 {$L LZHASM}
 {LZH_CUSTOM  : WORD  ; {Customized settings        
 LZH_ERROR   : WORD  ; {                           
 LZH_Message : String; { English response from
 LZH_VERSION : WORD  ; { Hibyte major, lobyte minor}

    

var
   LZH_ERROR    : Word; {for future use}
   StupidAlloc  : Boolean;
   StupidPtr    : Pointer;
   {$F+}
   WriteFromBuffer,
   ReadToBuffer: Procedure;
   LZHMem: ^LZHRec;
   LZHMemSeg       : WORD;
   {$F+}                            
   procedure Encode ;
   procedure Decode;

   Procedure InitLZH;
   Procedure DInitLZH;
Implementation
{$F+}
procedure Decode; External;
procedure Encode; External;




{$R-}
Procedure InitLZH;
{

If need be, call this routine before any other allocations, or...
Segment align all allocations.  This routine is setup to keep memory
allocations segment aligned, and to be backwards compatible with all
versions of Turbo Pascal, even though Borland isn't....

}
Begin
     
     StupidAlloc := True;
     GetMem (StupidPtr,8);
     If Ofs(StupidPtr^) = 0 Then Begin
        Freemem(StupidPtr,8);
        StupidAlloc := False;
        End;


     GetMem (LZHMem,(Sizeof(LZhmem^)AND $FFF0) +16);
     LZHMemSeg := Seg(LZhmem^);
     LZhmem^.Inend := 0;  { This is to insure that Read is called.      }
     LZhmem^.outend := 0; { If you don't fill the input, the engine will}





     {If you wonder why it locks up at any point, this is probably the cause}
     {If you changed this source, it's probably your fault.}

     {$IFDEF DEBUGLZH}
     Writeln (Seg(LZhmem^),':', ofs(LZhmem^));
     Writeln (Sizeof(LZhmem^));
     halt;
     {$ENDIF}



End;
Procedure DInitLZH;
Begin
     FreeMem (LZHMem,(Sizeof(LZhmem^)AND $FFF0) +16);
     if StupidAlloc then Freemem(StupidPtr,8);

End;

end.
