{JWR: The output scrolls without stopping.  You might want to replace
 "writeln;" with "readln;" so that you can follow along in the QPRO
 manual while you run the example. What I usually do for testing is
 just to redirect everything to a file from the command line and then
 examine the file.}

program fintest;
uses ufinance,ublock;

{ these types and consts are used for the IRR and NPV functions }

type
  xray3 = array [1..3] of extended;
  xray5 = array [1..5] of extended;
  xray7 = array [1..7] of extended;
  bt = object(extendedarrayblocktype) end;

const
  x1: xray3 = (-10,150,-145);
  x2: xray3 = (-10,150.1,-145);
  a: xray7 = (-3000,700,600,750,900,1000,1400);
  b: xray7 = (-50000,-8000,2000,4000,6000,5000,4500);
  c: xray7 = (-10000,1000,1000,1200,2000,3000,4000);
  a2: xray5 = (-5000,2000,2000,2000,2000);
  b2: xray7 = (8000,9000,8500,9500,10000,11000,10000);
  c2: xray7 = (200,350,-300,600,700,1000,1200);
  d2: xray7 = (3500,4000,3000,5000,4000,6500,7000);

  block1:bt = (c:3; d:@x1);
  block2:bt = (c:3; d:@x2);
  block3:bt = (c:7; d:@a);
  block4:bt = (c:7; d:@b);
  block5:bt = (c:7; d:@c);
  block6:bt = (c:5; d:@a2);
  block7:bt = (c:4; d:@a2[2]);
  block8:bt = (c:7; d:@b2);
  block9:bt = (c:7; d:@c2);
  block10:bt = (c:7; d:@d2);

begin

  writeln('Test of UFinance unit.  Examples from');
  writeln('    Quattro Pro 3.0 @Functions and Macros manual');
  writeln;
  writeln('page 29 (CTERM):');
  writeln(cterm(0.07,5000,3000):10:2);
  writeln(nper(0.07,0,-3000,5000,0):10:2,'(nper)');
  writeln(cterm(0.1,5000,3000):10:6);
  writeln(cterm(0.12,5000,3000):10:6);
  writeln(cterm(0.12,10000,7000):10:6);
  writeln;
  writeln('pages 35-36 (DDB):');
  writeln(ddb(4000,350,8,2):10:0);
  writeln(ddb(15000,3000,10,1):10:0);
  writeln(ddb(15000,3000,10,2):10:0);
  writeln(ddb(15000,3000,10,3):10:0);
  writeln(ddb(15000,3000,10,4):10:0);
  writeln(ddb(15000,3000,10,5):10:0);
  writeln;
  writeln('page 48 (FV):');
  writeln(fv(500,0.15,6):10:2);
  writeln(fval(0.15,6,-500,0,0):10:2,'(fval)');
  writeln(fv(200,0.12,5):10:2);
  writeln(fv(500,0.9,4):10:2);
  writeln(fv(800,0.9,3):10:2);
  writeln(fv(800,0.9,6):10:2);
  writeln;
  writeln('page 49 (FVAL):');
  writeln(fval(0.15,6,-500,0,1):10:2);
  writeln(fval(0.15,6,-500,-340,1):10:2);
  writeln;
  writeln('page 57 (IPAYMT):');
  writeln(ipaymt(0.1/12,2*12,30*12,100000,0,0):10:2);
  writeln;
  writeln('pages 57-58 (IRATE):');
  writeln(irate(5*12,-500,15000,0,0):10:5);
  writeln(irate(5,-2000,-2.38,15000,0):10:4);
  writeln;
  writeln('pages 60-61 (IRR):');
  writeln(irr(0,block1)*100:10:2,'%');
  writeln(irr(10,block1)*100:10:0,'%');
  writeln(irr(0,block2)*100:10:2,'%');
  writeln(irr(10,block2)*100:10:0,'%');
  writeln(irr(0,block3)*100:10:2,'%');
  writeln(irr(0,block4)*100:10:2,'%');
  writeln(irr(0,block5)*100:10:2,'%');
  writeln;
  writeln('page 73 (NPER):');
  writeln(nper(0.115,-2000,-633,50000,0):10:2);
  writeln;
  writeln('page 75 (NPV):');
  writeln(npv(0.1,block6,1):10:0);
  writeln(a2[1]+npv(0.1,block7,0):10:0);
  writeln(npv(0.0125,block8,0):10:2);
  writeln(npv(0.15/12,block9,0):10:0);
  writeln(npv(0.15/12,block10,0):10:0);
  writeln;
  writeln('page 77 (PAYMT):');
  writeln(paymt(0.175/12,12*30,175000,0,0):10:2);
  writeln(paymt(0.175/12,12*30,175000,0,1):10:2);
  writeln(paymt(0.175/12,12*30,175000,-80000,0):10:2);
  writeln;
  writeln('pages 78-79 (PMT)');
  writeln(pmt(10000,0.15/12,3*12):10:2);
  writeln(paymt(0.15/12,3*12,10000,0,0):10:2,'(paymt)');
  writeln(pmt(1000,0.12,5):10:2);
  writeln(pmt(500,0.16,12):10:2);
  writeln(pmt(5000,0.16/12,12):10:2);
  writeln(pmt(12000,0.11,15):10:2);
  writeln;
  writeln('page 79 (PPAYMT):');
  writeln(ppaymt(0.1/12,2*12,30*12,100000,0,0):10:2);
  writeln(ppaymt(0.15/4,24,40,10000,0,1):10:2);
  writeln;
  writeln('page 81 (PV)');
  writeln(pv(350,0.07/12,5*12):10:2);
  writeln(pval(0.07/12,5*12,-350,0,0):10:2,'(pval)');
  writeln(pv(277,0.12,5):10:2);
  writeln(pv(600,0.17,10):10:2);
  writeln(pv(100,0.11,12):10:2);
  writeln;
  writeln('page 82 (PVAL)');
  writeln(pval(0.1,12,2000,0,0):10:2);
  writeln(pval(0.1,15,0,30000,0):10:2);
  writeln;
  writeln('page 84 (RATE)');
  writeln(rate(4000,2000,10)*100:6:2,'%');
  writeln(rate(10000,7000,6*12)*100:6:2,'%');
  writeln(rate(1200,1000,3)*100:6:2,'%');
  writeln(rate(500,100,25)*100:6:2,'%');
  writeln;
  writeln('page 89 (SLN)');
  writeln(sln(4000,350,8):10:2);
  writeln(sln(15000,3000,10):10:0);
  writeln(sln(5000,500,5):10:0);
  writeln(sln(1800,0,3):10:0);
  writeln;
  writeln('pages 94-95 (SYD)');
  writeln(syd(4000,350,8,2):10:2);
  writeln(syd(12000,1000,5,1):10:0);
  writeln(syd(12000,1000,5,2):10:0);
  writeln(syd(12000,1000,5,3):10:0);
  writeln(syd(12000,1000,5,4):10:0);
  writeln(syd(12000,1000,5,5):10:0);
  writeln;
  writeln(ddb(12000,1000,5,1):10:0,'(ddb)');
  writeln(ddb(12000,1000,5,2):10:0,'(ddb)');
  writeln(ddb(12000,1000,5,3):10:0,'(ddb)');
  writeln(ddb(12000,1000,5,4):10:0,'(ddb)');
  writeln(ddb(12000,1000,5,5):10:0,'(ddb)');
  writeln;
  writeln('page 96 (TERM)');
  writeln(term(2000,0.11,50000):10:2);
  writeln(nper(0.11,-2000,0,50000,0):10:2,'(nper)');
  writeln(term(300,0.06,5000):10:1);
  writeln(term(500,0.07,1000):10:2);
  writeln(term(500,0.07,1000):10:2);
  writeln(term(1000,0.10,50000):10:1);
  writeln(term(100,0.05,1000):10:1);
end.
