unit ublock;

{ defines the "BlockType" object used for the UFinance NPV and IRR functions }
{ Copyright 1992 by J. W. Rider }
{ CIS mail: [70007,4652] }

interface

{$ifopt N-}
type
  extended = real;
{$endif}

type

  { the abstract "block": this is the type that is used for the
    type of "var" parameters in procedures and functions }
  BlockTypePtr = ^BlockType;
  BlockType = object
    function count: longint; virtual;  { number of values in "block" }
    function value(n:longint):extended; virtual; { return nth value }
    destructor done; virtual;
    end;

type
  ExtendedArrayPtr = ^ExtendedArray;
  ExtendedArray = array [1..$fff8 div sizeof(extended)] of extended;

type
  { a special-purpose block that extracts values from "extended" arrays.
    This is the type that would be declared as "const" or "var" or
    allocated on the heap in your program.  This one is very simple; you
    could easily extend the abstract block to other storage forms. }
    Note that "extended" means the same as "real" if $N-. }
  ExtendedArrayBlockTypePtr = ^ExtendedArrayBlockType;
  ExtendedArrayBlockType = object(BlockType)
    c: word;
    d: extendedarrayptr;
    function count:longint; virtual;
    function value(n:longint):extended; virtual;
    constructor init(dim:word; var firstvalue:extended);
    end;

implementation

function blocktype.count; begin count:=0 end;
function extendedarrayblocktype.count; begin count:=c; end;

destructor blocktype.done; begin end;

constructor extendedarrayblocktype.init; begin c:=dim; d:=@firstvalue; end;

function blocktype.value; begin value:=0; end;
function extendedarrayblocktype.value; begin value:=d^[n] end;

end.
