{ $D-}  { Disable Debug Information }
{$S-}  { Disable Stack Checking }
{$V-}  { Disable String Checking }

Unit GetCmBBS;
{ Part of BBS Onliner Interface }
{ Copyright (C) 1990, 1992 Andrew J. Mead
  All Rights Reserved. }

{ Original version 7/1/90 }
{ Original release version 9/5/90 }
{ Original public release 12/15/90 }
{ history found in IOLIB.PAS }

INTERFACE

IMPLEMENTATION

Uses
  boidecl,
  doorlib,
  iolib,
  crt,
  dos;

Type
  IRQtype   = array [0..15] of byte;     { array of IRQ information }
  portype   = array [0..3] of word;      { default port addressess  }
  buffarr   = array [0..$FFF0] of byte;

Var
  bi_char      : char;                   { standard input character    }
  bi_minmax    : byte;                   { maximum time allowed        }
  gc_exitfile  : pathstr;                { lets GC_EXIT find drop file }

Const
  bi_timedone  : boolean = false; { remaining time figured }
  bi_filedone  : boolean = false; { BBS file processed }
  bi_hofdone   : boolean = false; { /y processed }
  bi_lockcomm  : boolean = false; { /c processed }
  bi_lockIRQ   : boolean = false; { /i processed }
  bi_locklocal : boolean = false; { /l processed }
  bi_lockname  : boolean = false; { /n processed }
  bi_setlocal  : boolean = false; { BBS file says it is in local play }
  bi_portarray : portype =        { default port addressess for Com1 - Com4 }
      ($3F8,$2F8,$3E8,$2E8);
  IRQvector : IRQtype =        { interrupt vectors for IRQs 0 - 15 }
      ($08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$70,$71,$72,$73,$74,$75,$76,$77);
  IRQmask   : IRQtype =        { 8259A IRQ enabling masks-used in Async.Pas }
      ($FE,$FD,$FB,$F7,$EF,$DF,$BF,$7F,$FB,$FB,$FB,$FB,$FB,$FB,$FB,$FB);
   { Remember:  When using the cascade PIC, send the cascade mask (for IRQ2) }
  IRQ2msk   : IRQtype =        { cascade 8259A masks for IRQ8..IRQ15 }
      ($00,$00,$00,$00,$00,$00,$00,$00,$FE,$FD,$FB,$F7,$EF,$DF,$BF,$7F);

  IRQnum    : byte    = 4;     { default IRQ - Com1 Com3 }

Procedure GETCOMMAND;
  var
    gc_t        : text;        { user information text file handle }
    gc_f        : file;        { user information byte file handle }
    gc_buff     : ^buffarr;    { buffer for drop file }
    buffsize    : word;        { size of gc_buff^ }
    gc_fsize    : word;        { size of gc_f     }
    gc_str      : string;      { working string   }
    error       : word;        { Val conversion error value }
    timetemp    : real;        { Second/Minute time conversion variable }
    opchs       : string [2];  { Opus-CBCS Task Designation   }
    gc_loop     : byte;        { command line processing loop }
    spval       : byte;        { SetPort return value - (initialization check) }

{ The next major release of the BOI will have a thorough reworking of the
  error reporting section.  It will also contain optional activity logging
  and other features.  I have working code from other software I've written,
  but I haven't had time to port and test it.  I am welcome to suggestions
  and comments at this time - AJM (Dec 1992) }

  Procedure SHOWERROR(  { indicate error in processing drop file }
      param  : byte;      { internal error code }
      passtr : string);   { additional information to display }
    var s : text;       { errorlog file handle }

    Procedure WRITEERROR(   { write error to log file   }
        outstr : string);     { string to write to file }

      begin {* GetCommand,ShowError,WriteError *}
        WriteLn(s,DoorName);   { tell what door generated error }
        Write(s,'Abnormal termination of program at ');
        Write(s,boi_starttime[1]:1,':',boi_starttime[2]:1,':',
            boi_starttime[3]:1,'  ');  { show time of error }
        WriteLn(s,boi_startdate[2]:1,'/',boi_startdate[3]:1,'/',
            boi_startdate[1]:1,'.');   { show date of error }
        WriteLn(s,'ERROR ',param:0);
        WriteLn(outstr);
        WriteLn(s,outstr);
        WriteLn(s)
      end;  {* GetCommand,ShowError,WriteError *}

    begin  {* GetCommand,ShowError *}
      ClrScr; { Use console device for output }
      Assign(s,LogFile);  { open error log }
      if Exist(LogFile) then
          if OpenText(s,denywrite + writeonly,tappend) = 0 then else
      else if OpenText(s,denywrite + writeonly,trewrite) = 0 then;
      WriteLn(DoorName,' version ',Version,'.');
      WriteLn('Copyright (C) 1990, 1992 Andrew J. Mead');
      WriteLn('All Rights Reserved.');
      WriteLn('Contact: POB 1155 Chapel Hill, NC 27514-1155');
      WriteLn;
      WriteLn('Abnormal termination of program:');
      WriteLn;
      WriteLn('ERROR ',param:0);
      case param of
           2 : WriteError('Unknown or incorrect argument on command line.');
           3 : WriteError(passtr+' file format not supported yet.');
           4 : WriteError(
           'Unable to find '+passtr+'.  Check implementation or notify Sysop.');
           5 : WriteError('Error in '+passtr+'.  Check implementation.');
           7 : WriteError('Duplicate directives.');
           8 : WriteError('Path/Filename for Hall of Fame is not valid.');
           9 : WriteError(passtr+' is not a valid path.');
{         10 : WriteError('Invalid port setting(s) in '+passtr+'.'); }
          11 : WriteError('Invalid or missing numeric in /X:nn.');
          12 : WriteError('Hall of Fame limit out of range, must be in 1-19.');
          13 : WriteError(
                  'Invalid or missing value in /C:n.  ''n'' should be 1-8');
          16 : WriteError('/L can not be used with either /C or /I');
          17 : WriteError('Invalid format in /I:i:nnnn.');
          18 : WriteError(
              passtr+' is not a valid Hexadecimal address in /I statement.');
          19 : WriteError('Invalid numeric in /A:x.');
          20 : WriteError('/A timeleft should be at least 5.');
          31 : WriteError('Unable to find/initialize FOSSIL driver.')
        end;
      WriteLn;
      WriteLn('Check ',InfoFile,' for proper installation of this program.');
      WriteLn('Report error message to SysOp.');
      WriteLn;
      WriteLn('Error saved in ',LogFile,'.');
      Delay(5000); { five second delay }
      WriteLn('Now returning to BBS.');
      Close(s);
      Halt($FF) { abandon ship }
    end;  {* GetCommand,ShowError *}

  Procedure SETGAMETIME(   { convert dropfile time into BOI time }
      settime : word);       { time from drop file }

    begin {* GetCommand,SetGameTime *}
      boi_gametime := settime;
      boi_usetime := true;   { indicate that this IS a timed game }
      if boi_gametime < 10 then
          boi_gametime := 8      { give player at least 8 minutes }
      else Dec(boi_gametime,2);  { save 2 minutes for housekeeping }
      if bi_timedone then   { player gets lessor of /x and dropfile times }
          boi_gametime := Min(boi_gametime,bi_minmax - 2);
      boi_gametime := Min(boi_gametime,90)  { player gets no more than 90 mins }
    end;  {* GetCommand,SetGameTime *}

  Procedure FINDDROPFILE(
      var dropfile : pathstr);

    begin {* GetCommand,FindDropFile *}
      if bi_filedone then { dropfile has already been processed }
          ShowError(7,'')
      else bi_filedone := true;
      if Length(gc_str) > 2 then
        begin
          Delete(gc_str,1,2);
          if gc_str[1] = ':' then Delete(gc_str,1,1);
          if (Length(gc_str) > 0) and (
              not (gc_str[Length(gc_str)] in [':','\'])) then
              gc_str := gc_str + '\';
          dropfile := gc_str + dropfile; { add path to file name }
          if not Valid(dropfile) then { dropfilespec not valid DOS filespec }
              ShowError(9,gc_str)
        end;
      if not Exist(dropfile) then { dropfile not found }
          ShowError(4,dropfile)
    end;  {* GetCommand,FindDropFile *}

  Procedure PROCESSTEXT(      { process BBS system text file for user info }
      txt_file     : pathstr;   { name of BBS system file }
      txt_usename  : boolean;   { username is in file indicator }
      txt_usetime  : boolean;   { user time remaining is in file indicator }
      txt_useplen  : boolean;   { user screen length is in file indicator }
      txt_ismins   : boolean;   { user time remaining is in minutes indicator }
      txt_nameline : byte;      { line at which users name is found }
      txt_timeline : byte;      { line at which users time remaining is found }
      txt_lineline : byte;      { line at which users screen length is found }
      txt_comline  : byte;      { line at which the comport is listed }
      txt_combyte  : byte;      { byte in comline that determines comport }
      txt_extra    : byte);     { extra information for a given file - switch }

    Procedure RESTART(      { read a given line number from text file }
        readline : byte);     { line to read }
        { places the given lines information in gc_str }
      var
        rloop : byte;

      begin {* GetCommand,ProcessText,Restart *}
        if OpenText(gc_t,denynone + read_only,treset) = 0 then; { reset file }
        {$I-}
        for rloop := 1 to readline do ReadLn(gc_t,gc_str);
        {$I+}
        if IOResult <> 0 then
            ShowError(5,txt_file) { file too short }
      end;  {* GetCommand,ProcessText,Restart *}

    Procedure DORBBS;
    { get users last name, and append it to the first name }

      begin {* GetCommand,ProcessText,DoRBBS *}
        Restart(8); { Get user's last name }
        boi_username := boi_username + ' ' + gc_str
      end;  {* GetCommand,ProcessText,DoRBBS *}

    Procedure DOWWIV;
    { check to see if game is being played locally or from remote }
    { get user's real name }

      begin {* GetCommand,ProcessText,DoWWIV *}
        Restart(15);
        CleanString(gc_str);
        if (Length(gc_str) > 0) and (gc_str[1] = '0') then bi_setlocal := true;
        Restart(3);
        boi_usereal := true;
        boi_realname := gc_str;
        Restart(1);
        boi_realname := '#'+ gc_str + ' ' + boi_realname
      end;  {* GetCommand,ProcessText,DoWWIV *}

    Procedure DOSPITFIRE;
    { get user's user number }

      begin {* GetCommand,ProcessText,DoSpitfire *}
        Restart(1);
        boi_usereal := true;
        boi_realname := '#' + gc_str;
        {* code from John Reid *}
        Restart(5);
        if gc_str[1] = '0' then bi_setlocal := true
      end;  {* GetCommand,ProcessText,DoSpitfire *}

    Procedure DOWILDCAT; { CALLINFO.BBS }
    { check to see if game is being played locally or from remote }

      begin {* GetCommand,ProcessText,DoWildCat *}
        Restart(28);
        if Pos('LOCAL',gc_str) > 0 then bi_setlocal := true
      end;  {* GetCommand,ProcessText,DoWildCat *}

    Procedure DO2AM;
      begin {* GetCommand,ProcessText,Do2AM *}
        Restart(6); { Get user's last name }
        boi_username := boi_username + ' ' + gc_str;
        Restart(3);
        boi_usereal := true;
        boi_realname := gc_str
      end;  {* GetCommand,ProcessText,Do2AM *}

    Procedure DOPHOENIX;
      begin {* GetCommand,ProcessText,DoPhoenix *}
        Restart(2);
        if Pos('LOCAL',gc_str) > 0 then bi_setlocal := true
      end;  {* GetCommand,ProcessText,DoPhoenix *}

    begin {* GetCommand,ProcessText *}
      FindDropFile(txt_file); { verify dropfile }
      Assign(gc_f,txt_file); { open as binary file to get file size }
      if OpenFile(gc_f,1,denynone + read_only,treset) = 0 then;
      buffsize := FileSize(gc_f);
      Close(gc_f);           { close file }
      GetMem(gc_buff,buffsize); { allocate buffer on heap }
      Assign(gc_t,txt_file);
      SetTextBuf(gc_t,gc_buff^,buffsize); { assign buffer to file handle }

      { get user's name }
      if txt_usename then
        begin
          Restart(txt_nameline);
          boi_usename := true;
          boi_username := Copy(gc_str,1,39)
        end
      else boi_usename := false;

      { get user's time remaining }
      if txt_usetime then
        begin
          Restart(txt_timeline);
          CleanString(gc_str);
          Val(gc_str,timetemp,error);
          if error <> 0 then ShowError(5,txt_file); { error in conversion }
          if txt_ismins then SetGameTime(Trunc(timetemp))
          else SetGameTime(Trunc(timetemp/60.0)) { tranlate seconds to minutes }
        end
      else boi_usetime := false;

      { get user's screen size }
      if txt_useplen then
        begin
          Restart(txt_lineline);
          CleanString(gc_str);
          Val(gc_str,boi_pagelength,error);
          if error <> 0 then ShowError(5,txt_file); { error in conversion }
          if boi_pagelength > 24 then { reserve one line for status line }
              Dec(boi_pagelength)
        end;

      { get communication's port / local play mode info }
      if not (bi_lockcomm or bi_locklocal or bi_lockIRQ) then
        begin
          Restart(txt_comline);
          case gc_str[txt_combyte] of
              '0' : bi_setlocal := true; { COM0 == Local mode }
              '1'..'4' :
                begin
                  boi_local := false;
                  if gc_str[txt_combyte] in ['2','4'] then IRQnum := 3;
                  boi_portnum := Ord(gc_str[txt_combyte]) - Ord('1')
                  { portnum is one less than commnum 0==COM1, 1==COM2, etc... }
                end
            end
        end;
      case txt_extra of { some drop files need special processing }
          1 : DoRBBS;
          2 : DoWWIV;
          3 : DoWildCat;
          4 : Do2AM;
          5 : DoPhoenix;
          6 : DoSpitfire
        end;
      Close(gc_t); { close dropfile }
      FreeMem(gc_buff,buffsize)  { release buffer's memory back to heap }
    end;  {* GetCommand,ProcessText *}

  Procedure PROCESSFILE(     { process BBS system data file for user info }
      bin_file    : pathstr;   { name of BBS system file }
      bin_usename : boolean;   { username is in file indicator }
      bin_usetime : boolean;   { user time remaining is in file indicator }
      bin_useplen : boolean;   { user screen length is in file indicatior }
      bin_ismins  : boolean;   { user time remaining is in minutes indicator }
      bin_nameoff : word;      { username offset      }
      bin_namesiz : byte;      { username string size }
      bin_timeoff : word;      { user time offset     }
      bin_lineoff : word;      { user screen length offset  }
      bin_commoff : word;      { communication port offset  }
      bin_local   : word;      { local mode indicator value }
      bin_extra   : byte);     { extra processing switch    }

    Procedure DOOPUS114;
    { get user's real name }
      begin {* GetCommand,ProcessFile,DoOpus114 *}
        Move(gc_buff^[0],boi_realname[1],36);
        boi_realname[0] := Chr(36);
        if Pos(#0,boi_realname) > 0 then
            boi_realname[0] := Chr(Pos(#0,boi_realname) - 1)
        else CleanString(boi_realname);
        if Length(boi_realname) > 0 then
            if (Length(boi_username) = 0) then
                boi_username := boi_realname
            else boi_usereal := true
      end;  {* GetCommand,ProcessFile,DoOpus114 *}

    begin {* GetCommand,ProcessFile *}
      FindDropFile(bin_file); { verify dropfile }
      gc_exitfile := bin_file;
      Assign(gc_f,bin_file); { open dropfile }
      if OpenFile(gc_f,1,denynone + read_only,treset) = 0 then;
      buffsize := FileSize(gc_f);
      GetMem(gc_buff,buffsize); { allocate dropfile sized buffer on heap }
      BlockRead(gc_f,gc_buff^,buffsize,gc_fsize); { read file into buffer }
      Close(gc_f); { close file, get data from buffer }

      { get user's name }
      if bin_usename and not bi_lockname then
        begin
          Move(gc_buff^[bin_nameoff],boi_username[1],bin_namesiz);
          boi_username[0] := Chr(bin_namesiz);
          if Pos(#0,boi_username) > 0 then
              boi_username[0] := Chr(Pos(#0,boi_username) - 1)
          else CleanString(boi_username);
          boi_usename := true
        end
      else boi_usename := false;

      { get user's time remaining }
      if bin_usetime then
        begin
          if bin_ismins then { time is already in minutes }
              Move(gc_buff^[bin_timeoff],boi_gametime,SizeOf(word))
          else Move(gc_buff^[bin_timeoff],timetemp,SizeOf(real));
          if bin_ismins then SetGameTime(boi_gametime)
          else SetGameTime(Trunc(timetemp/60.0)) { convert seconds to minutes }
        end
      else boi_usetime := false;

      { get user's screen size }
      if bin_useplen then
        begin
          Move(gc_buff^[bin_lineoff],boi_pagelength,1);
          if bin_extra = 1 then Inc(boi_pagelength,2);
          if boi_pagelength > 24 then Dec(boi_pagelength)
        end;

      { get communication's port / local play info }
      if not (bi_lockcomm or bi_locklocal or bi_lockIRQ) then
        begin                      { get communications port }
          if bin_extra = 1 then { Opus 1.14 processes differently }
            begin
              { local mode is indicated at another offset }
              if (gc_buff^[bin_local] or gc_buff^[bin_local]) = 0 then
                  bi_setlocal := true
              else
                begin
                  boi_local := false;
                  if gc_buff^[bin_commoff] in [1,3] then { 1,3 == COM2,COM4 }
                      IRQnum := 3;
                  boi_portnum := gc_buff^[bin_commoff];
                end
            end
          else case Chr(gc_buff^[bin_commoff]) of
              #0,'0','L' : bi_setlocal := true;
              '1'..'4',#1..#4 :
                begin
                  boi_local := false;
                  if Chr(gc_buff^[bin_commoff]) in [#2,#4,'2','4'] then
                      IRQnum := 3;
                  if gc_buff^[bin_commoff] in [1..4] then
                      boi_portnum := gc_buff^[bin_commoff] - 1
                  else boi_portnum := gc_buff^[bin_commoff] - Ord('1')
                end
            end
        end;

      case bin_extra of { some dropfiles require additional processing }
          1 : DoOpus114
        end;
      FreeMem(gc_buff,buffsize) { release dropfile buffer memory to heap }
    end;  {* GetCommand,ProcessFile *}

  Procedure DoPCBoard12( { Process drop file from PCBoard 12.x and Auntie BBS }
      pc_file : pathstr);  { name of drop file }

    var
      pc_time : real;
      pc_mask : array [1..6] of byte absolute pc_time;
    { PC Board times are in seconds stored as 4 byte reals (QBasic I think) }
    { they must be converted into Turbo Pascal 6 byte reals, before being   }
    { converted into longint. }

    begin {* GetCommand,DoPCBoard12 *}
      FindDropFile(pc_file);
      Assign(gc_f,pc_file); { open dropfile }
      if OpenFile(gc_f,1,denynone + read_only,treset) = 0 then;
      buffsize := FileSize(gc_f);
      GetMem(gc_buff,buffsize); { allocate dropfile sized buffer on heap }
      BlockRead(gc_f,gc_buff^,buffsize,gc_fsize); { read drop file into buffer }
      Close(gc_f); { close file, get info from buffer }

      {get user's name }
      Move(gc_buff^[14],boi_username[1],25);
      boi_username[0] := Chr(25);
      if Pos(#0,boi_username) > 1 then
          boi_username[0] := Chr(Pos(#0,boi_username) - 1)
      else CleanString(boi_username);
      boi_usename := true;

      { convert stored real format to Turbo Pascal real format }
      pc_mask[1] := gc_buff^[79];
      pc_mask[2] := $00;
      pc_mask[3] := $00;
      pc_mask[4] := gc_buff^[76];
      pc_mask[5] := gc_buff^[77];
      pc_mask[6] := gc_buff^[78];

      { get game time }
      SetGameTime(Trunc(pc_time/60.0)); { covert real seconds to word minutes }

      { get communications port / local play information }
      if not (bi_lockcomm or bi_locklocal or bi_lockIRQ) then
          if gc_buff^[10] = ord('L') then bi_setlocal := true;
      FreeMem(gc_buff,buffsize) { release buffer memory back to heap }
    end;  {* GetCommand,DoPCBoard12 *}

  Procedure DOSEARCHLIGHT;
  { This works not just with Searchlight BBS, but it indicates that all     }
  { information will passed via command line. }

    begin {* GetCommand,DoSearchLight *}
      if bi_filedone then { dropfile already processed }
          ShowError(7,'')
      else bi_filedone := true
    end;  {* GetCommand,DoSearchLight *}

  Procedure GETCOMPORT;
  { set communications port by command line directive }
    begin {* GetCommand,GetComPort *}
      bi_lockcomm := true;
      if bi_locklocal then ShowError(16,''); { /C and /L are incompatible }
      boi_local := false;
      if (gc_str[Length(gc_str)] in ['1'..'8']) then
          boi_portnum := Ord(gc_str[Length(gc_str)]) - Ord('1')
      else ShowError(13,'');
      if boi_portnum in [1,3] then IRQnum := 3; { COM2, COM4 }
    end;  {* GetCommand,GetComPort *}

  Procedure GETIRQINFO;
  { set IRQ and port information by command line directive }
    var
      IRQerror : word;

    begin {* GetIRQInfo *}
      bi_lockIRQ := true;
      if bi_locklocal then ShowError(16,''); { /I and /L are incompatible }
      boi_local := false;
      foss_init := foss_init OR $01; { turn FOSSIL checking off! }
      Delete(gc_str,1,2);
      if gc_str[1] = ':' then Delete(gc_str,1,1);
      if UpCase(gc_str[1]) in ['0'..'9','A'..'F'] then
        begin
          IRQnum  := Hex(gc_str[1]);         { assign IRQ number }
          boi_portint := IRQvector[IRQnum];  { get interrupt vector for IRQ }
          boi_picmask := IRQmask[IRQnum];    { get interrupt mask for IRQ }
          boi_cascade := gc_str[1] > '7';    { IRQ8..IRQ15 on cascade PIC }
          boi_pic2msk := IRQ2msk[IRQnum];
          Delete(gc_str,1,1);
          if gc_str[1] = ':' then Delete(gc_str,1,1)
          else ShowError(17,'') { Error in /I:i:nnnn format }
        end
      else ShowError(17,''); { Error in /I:i:nnnn format }
      if Length(gc_str) <> 4 then ShowError(17,'');
      Val('$' + gc_str,boi_portadd,IRQerror);
      if IRQerror > 0 then ShowError(18,gc_str)
    end;  {* GetIRQInfo *}

  Procedure GETHOFLIM;
  { limit player Hall of Fame appearances }
    var
      error : word;

    begin {* GetCommand,GetHofLim *}
      if Length(gc_str) < 3 then ShowError(2,'');
      Delete(gc_str,1,2);
      if gc_str[1] = ':' then Delete(gc_str,1,1);
      Val(gc_str,boi_hoflim,error);
      if error > 0 then ShowError(11,'');
      if not (boi_hoflim in [1..19]) then ShowError(12,'')
    end;  {* GetCommand,GetHofLim *}

  Procedure GETHOF;
  { redirect text Hall of Fame output }
    begin {* GetCommand,GetHOF *}
      bi_hofdone := true;
      if Length(gc_str) < 3 then ShowError(2,'');
      Delete(gc_str,1,2);
      if gc_str[1] = ':' then Delete(gc_str,1,1);
      if (Pos('.',gc_str) = 0) then
        begin
          if (gc_str[Length(gc_str)] in [':','\']) then
              gc_str := gc_str + TxtHOF
          else gc_str := gc_str + '\' + TxtHOF
        end;
      if not Valid(gc_str) then ShowError(8,'')
      else boi_texthof := gc_str
    end;  {* GetCommand,GetHOF *}

  Procedure GETTIMELIMIT; { set maximum time limit }
    begin {* GetCommand,GetTimeLimit *}
      bi_timedone := true;
      if Length(gc_str) < 3 then ShowError(2,'');
      Delete(gc_str,1,2);
      if gc_str[1] = ':' then Delete(gc_str,1,1);
      Val(gc_str,bi_minmax,error);
      if error <> 0 then ShowError(8,'');
      if bi_filedone then boi_gametime := Min(boi_gametime,bi_minmax - 2)
      else
        begin
          boi_usetime := true;
          boi_gametime := Min(bi_minmax - 2,90)
        end
    end;  {* GetCommand,GetTimeLimit *}

  Procedure DOPORTS; { use default IRQ and port information for communications }
    begin {* GetCommand,DoPorts *}
      boi_portadd := bi_portarray[boi_portnum];
      boi_portint := IRQvector[IRQnum];
      boi_picmask := IRQmask[IRQnum]
    end;  {* GetCommand,DoPorts *}

  Procedure GETAGAIN; { get multiple play parameters }
    var
      error : word;

    begin {* GetCommand,GetAgain *}
      boi_replay := true;
      Delete(gc_str,1,2);
      if gc_str[1] = ':' then Delete(gc_str,1,1);
      If Length(gc_str) > 0 then
        begin
          Val(gc_str,boi_againtime,error);
          if error > 0 then ShowError(19,'');
          if boi_againtime < 5 then { must be at least 5 minutes left }
              ShowError(20,'')
        end
      else boi_againtime := 10 { default minimum time for replay }
    end;  {* GetCommand,GetAgain *}

  Procedure GETNAME; { get user's name from command line }
    var
      gloop : byte;

    begin {* GetCommand,GetName *}
      Delete(gc_str,1,2);
      if gc_str[1] = ':' then Delete(gc_str,1,1);
      if Length(gc_str) > 0 then
        begin
          bi_lockname := true;
          boi_usename := true;
          boi_username := gc_str;
          { convert '_' (underscores) to ' ' (spaces) }
          for gloop := 1 to Length(boi_username) do
              if boi_username[gloop] = '_' then
              boi_username[gloop] := ' '
        end
    end;  {* GetCommand,GetName *}

{ slash '/' switches }
{    active switches :  12 4567 9ABCD FGHI KLMNOPQRST VWXYZ }
{  reserved switches : 0  3    8     E                      }
{ available switches :                    J          U      }
{   program switches : +-][=.                               }

{ dash '-' switches } { unused at this point }
{    active switches :                                      }
{  reserved switches :                                      }
{ available switches : 0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ }

  begin {* GetCommand *}
    boi_usetime  := false;       { default - no time limit }
    boi_usename  := false;       { default - no user name }
    boi_usereal  := false;       { default - only know alias }
    boi_pagelength := 24;        { default - 24 line screen }
    boi_timexp   := false;       { set time to not expired }
    for gc_loop := 1 to ParamCount do
      begin
        gc_str := ParamStr(gc_loop);
        if (gc_str[1] = '/') and (Length(gc_str) > 1) then
            case UpCase(gc_str[2]) of
{PCBoard12x}'1' : DoPCBoard12('PCBoard.Sys');
{2 A.M.}    '2' : ProcessText('Jumper.Dat',  true,true,false,true,  5, 8, 0, 9,4,4);
{Opus 1.13} '3' : ShowError(3,'Opus-CBCS 1.13 '); { no docs for Opus 1.13 }
{WWIV,TG}   '4' : ProcessText('Chain.Txt',   true,true,true, false, 2,16,10,21,1,2);
{RyBBS}     '5' : ProcessText('CurrUser.BBS',true,true,false,true,  1,13, 0, 6,1,0);
{Spitfire}  '6' : ProcessText('SFDoors.Dat', true,true,false,true,  2, 7, 0, 6,1,6);
{Auntie}    '7' : DoPCBoard12('Auntie.Sys');
{Sapphire}  '8' : ShowError(3,'Sapphire BBS '); { no docs for Sapphire BBS }
{SeachLight}'9' : DoSearchLight;
{GT Power}  '0' : ShowError(3,'GT Power '); { no docs for CURRUSER.BBS }
{DoorWay}   'D' : ProcessText('Door.Sys',    true,true,false,true,  1, 4, 0, 2,1,0);
{Forum}     'F' : ProcessText('UserInfo.Txt',true,true,false,false, 1, 4, 0, 5,1,0);
{Genesis}   'G' : ProcessText('CallInfo.BBS',true,true,true, true,  1, 5,23,25,1,3);
{Phoenix}   'H' : ProcessText('Info.Txt',    true,true,false,true,  1, 7, 0, 3,1,5);
{ModuleX}   'M' : ProcessText('Number.Txt',  true,true,false,false, 1, 4, 0, 5,1,0);
{PCBoard14x}'P' :
              begin
                ProcessFile('PCBoard.Sys', true,true,false,true ,84,25,109, 0,125,18,0);
                boi_dmode := df_pcb14x { extra processing needed with carrier loss }
              end;
{GAP,Force} 'S' : ProcessText('Door.Sys',    true,true,true, true, 10,19,21, 1,4,0);
{-WildCat,VBBS,etc...}
{UBBS}      'U' : ShowError(3,'UBBS '); { no docs for UBBS }
{WildCat}   'W' : ProcessText('CallInfo.BBS',true,true,true, true,  1, 5,23,29,4,3);
{Opus 1.14} 'O' :
              begin
                if (Length(gc_str) > 3) and (UpCase(gc_str[3]) in ['0'..'9','A'..'F'])
                    and (UpCase(gc_str[4]) in ['0'..'9','A'..'F']) then
                  begin
                    opchs := Copy(gc_str,3,2);
                    Delete(gc_str,3,2);
                    ProcessFile('LastUS'+opchs+'.Dat',true,true,true,true,104,32,1030,173,1026,1024,1)
                  end
                else ProcessFile('LastUser.Dat',true,true,true,true,104,32,1030,173,1026,1024,1)
              end;
{EIS-PC}    'R' :
{FoReM}       begin  { Get node number }
{OLEcom}        if (length(gc_str) > 2) and (gc_str[3] in ['0'..'9']) then
{QuickBBS}        begin
{RBBS}              bi_char := gc_str[3];
{Remote Access}     delete(gc_str,3,1);
{TAG}               ProcessText('DorInfo'+bi_char+'.Def',true,true,false,true,7,12,0,4,4,1)
{TP-Board}        end
                else ProcessText('DoorInfo.Def',true,true,false,true,7,12,0,4,4,1)
              end;

{Local}     'L' : if bi_locklocal then ShowError(7,'') else bi_locklocal := true;
{lockcomm}  'C' : if bi_lockcomm or bi_lockIRQ then ShowError(7,'')
                else if not bi_setlocal then GetComPort;
{lockIRQ}   'I' : if bi_lockcomm or bi_lockIRQ then ShowError(7,'')
                else if not bi_setlocal then GetIRQInfo;

{doagain}   'A' : if boi_replay then ShowError(7,'') else GetAgain;
{baudlock}  'B' : if boi_ctsrts then ShowError(7,'') else boi_ctsrts := true;
{getname}   'N' : if bi_lockname then ShowError(7,'') else GetName;
{checkcd}   'K' : if not boi_checkcd then ShowError(7,'') else boi_checkcd := false;
{doquiet}   'Q' : if boi_quiet then ShowError(7,'') else boi_quiet := true;
{hoflim}    'X' : if boi_hoflim < 20 then ShowError(7,'') else GetHofLim;
{hofpath}   'Y' : if bi_hofdone then ShowError(7,'') else GetHOF;
{timelimit} 'Z' : if bi_timedone then ShowError(7,'') else GetTimeLimit;
          end
        else if ProgramSet(gc_str[1]) then  { program defined symbols }
          begin
            case gc_str[1] of
                '+' : if boi_plusidx  = 0 then boi_plusidx  := gc_loop else ShowError(7,'');
                '-' : if boi_minusidx = 0 then boi_minusidx := gc_loop else ShowError(7,'');
                ']' : if boi_closeidx = 0 then boi_closeidx := gc_loop else ShowError(7,'');
                '[' : if boi_openidx  = 0 then boi_openidx  := gc_loop else ShowError(7,'');
                '=' : if boi_equalidx = 0 then boi_equalidx := gc_loop else ShowError(7,'');
                '.' : if boi_dotidx   = 0 then boi_dotidx   := gc_loop else ShowError(7,'')
              end
          end
        else if UpCase(gc_str[1]) = 'F' then { FOSSIL kludge }
          begin
            if Pos('-',gc_str) > 0 then
                foss_init := foss_init OR $01  { do NOT check for FOSSIL }
            else if Pos('+',gc_str) > 0 then
                foss_init := foss_init OR $02; { only user FOSSIL }
            if Pos('@',gc_str) > 0 then
                foss_init := foss_init OR $04  { de-initialize FOSSIL when done}

{  foss_init                                   }
{  lower bits hold precedence                  }

{  $01   1  Force No Fossil           F-       }
{  $02   2  Force Fossil              F+       }
{  $04   4  De-Init FOSSIL            F@       }
{  $08   8  undefined                          }
{  $10  16  reserved                           }
{  $20  32  reserved                           }
{  $40  64  reserved                           }
{  $80 128  reserved                           }

          end
        else if UpCase(gc_str[1]) = 'A' then { AVATAR/1 kludge }
          begin {* kludge *}
            if Pos('+',gc_str) > 0 then boi_allowavt := true
          end   {* kludge *}
        else ShowError(2,'')
      end;
    if bi_locklocal and (bi_lockcomm or bi_lockIRQ) then
        ShowError(16,''); { can't have /L with either /C or /I }
    if bi_locklocal or bi_setlocal then boi_local := true;
    boi_echo := not boi_local;
    if not (boi_local or bi_lockIRQ) then DoPorts; { get default IRQ info }
    if not bi_hofdone then { put default text HOF in game's .EXE directory }
        boi_texthof := boi_gamedir + TxtHOF;
    if boi_usetime then { convert time remaining into timer ticks 18.2/second }
        boi_ticks := longint(boi_gametime) * 1092; { 1092 ticks per minute }

    spval := SetPort; { attempt to initialize comm port }
    if spval > 0 then { communications initialization failed }
        ShowError(spval,'')
  end;  {* GetCommand *}

Var
  bi_nextexit : pointer;  { pointer to hold address of next Exit procedure }

{$F+}
Procedure GCEXIT;
  var
    f        : file;     { file handle for post-processing }
    exitbuff : ^buffarr; { buffer to hold drop file }
    exitsize : word;     { size of drop file }

  begin {* GCExit *}
    exitproc := bi_nextexit;
    if (not boi_local) and boi_cdlost and (boi_dmode = df_pcb14x) then
      begin
        { fill PCBOARD.SYS after byte nine with spaces if carrier lost }
        Assign(f,gc_exitfile); { open dropfile }
        if OpenFile(f,1,denynone + read_only,treset) = 0 then;
        exitsize := FileSize(f); { get file size }
        GetMem(exitbuff,exitsize); { allocate dropfile sized buffer on heap }
        BlockRead(f,exitbuff^,exitsize); { read file into buffer }
        FillChar(exitbuff^[9],exitsize - 9,' '); { blank out data }
        if OpenFile(f,1,denyall + writeonly,trewrite) = 0 then; { erase file }
        BlockWrite(f,exitbuff^,exitsize); { write blanked file }
        Close(f); { close file, get data from buffer }
        FreeMem(exitbuff,exitsize) { release buffer's memory back to heap }
      end
  end;  {* GCExit *}
{$F-}

begin {* uGetCmBBS *}
  bi_nextexit := exitproc;
  exitproc := @GCExit;
  { LoadLanguage; stay tuned for future developements! }
  GetCommand
end.  {* uGetCmBBS *}

Text Data Files
  BBS System      SynData File    type   Name  Real  Time  Line  Comm  Local
x 2 A.M. BBS         Jumper.Dat   text    5+6    3     8m  ----   9,4  ----
x DoorWay          2 Door.Sys     text      1  ----    4m  ----   2,1  ----
x EIS-PC           3 DorInfo#.Def text    7+8  ----   12m  ----   4,4  ----
x Force BBS        1 Door.Sys     text     10  ----   19m   21    1,4  ----
x FoReM            3 DorInfo#.Def text    7+8  ----   12m  ----   4,4  ----
x Forum            4 UserInfo.Txt text      1  ----    4s  ----   5,1   5,L
x GAP              1 Door.Sys     text     10  ----   19m   21    1,4  ----
  Genesis            CallInfo.BBS text      1  ----    5m   23    ???  28,L
x GT               2 Door.Sys     text      1  ----    4m  ----   2,1  ----
x ModuleX          4 Number.Txt   text      1  ----    4s  ----   5,1   5,L
x OLEcom           3 DorInfo#.Def text    7+8  ----   12m  ----   4,4  ----
x Phoenix            Info.BBS     text      1  ----    7m  ----   3,1   2,L
x Quick BBS        3 DorInfo#.Def text    7+8  ----   12m  ----   4,4  ----
x RBBS             3 DorInfo#.Def text    7+8  ----   12m  ----   4,4  ----
x Remote Acces     3 DorInfo#.Def text    7+8  ----   12m  ----   4,4  ----
x RyBBS              CurrUser.BBS text      1  ----   13m  ----   6,1  ----
x Spitfire BBS       SFDoors.Dat  text      2  ----    7m  ----   6,1  ----
x TAG              3 DorInfo#.Def text    7+8  ----   12m  ----   4,4  ----
x TP-Board         3 DorInfo#.Def text    7+8  ----   12m  ----   4,4  ----
x WildCat 2.x        CallInfo.BBS text      1  ----    5m   23   29,4  28,L
x WildCat 3.x      1 Door.Sys     text     10  ----   19m   21    1,4  ----
x WWIV               Chain.Txt    text      2    3    16s   10   21,1  15,0
x Telegard         x Can emulate most of the above

Binary Data Files
  BBS System      SynData File    type   Name  Real  Time  Line  Comm  Local
- Auntie BBS       5 Auntie.Sys   b128   14n25 ----   76c  ----  ----  10,L
  OPUS-CBCS 1.13     LastUser.BBS b128    0l   ----   ???  123   ????  ????
- OPUS-CBCS 1.14     LastUsXX.Dat b     104n32 0n36 1030mw 173  1026w  ----
- PCBoard 12.x     5 PCBoard.Sys  b128   14n25 ----   76c  ----  ----  10,L
x PCBoard 14.x       PCBoard.Sys  b128   84n25 ----   61mw ----  125c  18,L
                                                     110mw
  Sapphire BBS       Sapphire.Dat b545    0l   ----   ???   87   ????  ????

Command Line Driven
x Search Light BBS

x in use
- beta stage

m minutes
s seconds

r real
i integer
w word
c char
