{
Turbo Pascal ANSI Drivers
Version 1.12
Copyright (c) 1990 by Not So Serious Software

Original concept by Ian Silver
Design and implementation by Kevin Dean

Kevin Dean
Fairview Mall P.O. Box 55074
1800 Sheppard Avenue East
Willowdale, Ontario
CANADA    M2J 5B9
CompuServe ID: 76336,3114
}


{$I-,F-,S-,R-}
unit ANSICON;


interface


uses
  DOS,
  ANSI;


procedure AssignCON(var F : Text);
function KeyPressed : boolean;
function ReadKey : char;

{ These functions are not to be called directly; they are used internally }
function ConsoleIn(var F : Text) : integer;
function ConsoleOut(var F : Text) : integer;


implementation


const
  KeyPending : boolean =	{ Set by KeyPressed, true if key has been read from console }
    false;

var
  PendingKey : char;		{ Key read by KeyPressed }


{$F+}

{***}
{ Handle line-oriented console input }
function ConsoleIn(var F : Text) : integer;

var
  NumRead : integer;	{ Number of characters read }
  Done : boolean;	{ True if end of line }
  Regs : Registers;	{ MS-DOS registers }

begin
NumRead := 0;

Done := false;
while not Done do
  begin
  if KeyPending then
    KeyPending := false
  else
    begin
    Regs.AH := $07;
    MSDOS(Regs);
    PendingKey := Chr(Regs.AL)
    end;

  case PendingKey of
    NUL:
      { Ignore extended keys }
      begin
      Regs.AH := $07;
      MSDOS(Regs)
      end;

    BRK:
      if CheckBreak then
	begin
	WriteLn('^C');
	inline
	(
	$CD/$23		{ INT	23h }
	)
	end;

    BS:
      { Erase last character if possible }
      if (NumRead <> 0) and (WhereX <> 1) then
	begin
	Write(BS, ' ', BS);
	Dec(NumRead)
	end;

    CR, LF:
      { End of line }
      begin
      Done := true;
      TextRec(F).BufPtr^[NumRead] := CR;
      Inc(NumRead);
      TextRec(F).BufPtr^[NumRead] := LF;
      Inc(NumRead);
      WriteLn
      end;

    EOF_:
      { End of file }
      if CheckEOF then
	begin
	Done := true;
	TextRec(F).BufPtr^[NumRead] := EOF_;
	Inc(NumRead)
	end;

    ESC:
      { Clear current input }
      begin
      Write('\', LF);
      if MaxX = 0 then
	GotoXY(WhereX - NumRead - 1 + MaxX, WhereY)
      else
	GotoXY((WhereX - NumRead + MaxX - 2) mod MaxX + 1, WhereY);
      NumRead := 0
      end;

    else
      { Display the character }
      with TextRec(F) do
	if NumRead < BufSize - 2 then
	  begin
	  BufPtr^[NumRead] := PendingKey;
	  Write(PendingKey);
	  Inc(NumRead)
	  end
    end
  end;

{ Save buffer pointers }
with TextRec(F) do
  begin
  BufPos := 0;
  BufEnd := NumRead
  end;

ConsoleIn := 0
end;


{***}
{ Display text on console }
function ConsoleOut(var F : Text) : integer;

var
  I : integer;		{ Index into buffer }
  Regs : Registers;	{ MS-DOS registers }

begin
with TextRec(F) do
  begin
  for I := 0 to BufPos - 1 do
    begin
    Regs.AH := $06;
    Regs.DL := Ord(BufPtr^[I]);

    if Chr(Regs.DL) = FF then
      { Translate form feed }
      ClrScr
    else
      begin
      { DL = $FF means read character, so translate to NUL }
      if Regs.DL = $FF then
	Regs.DL := Ord(NUL);

      MSDOS(Regs)
      end
    end;

  BufPos := 0
  end;

ConsoleOut := 0
end;


{***}
{ Flush console buffer }
function ConsoleFlush(var F : Text) : integer;

begin
with TextRec(F) do
  if Mode = fmInput then
    { Ignore flush request }
    ConsoleFlush := 0
  else
    { Chain to F's default output routine }
    ConsoleFlush := IOFunc(InOutFunc)(F)
end;


{***}
{ Open console for input or output }
function ConsoleOpen(var F : Text) : integer;

begin
with TextRec(F) do
  if Mode = fmInput then
    IOFunctions(UserData).NextInOut := @ConsoleIn
  else
    IOFunctions(UserData).NextInOut := @ConsoleOut;

ConsoleOpen := 0
end;


{***}
{ Close console (do nothing) }
function ConsoleClose(var F : Text) : integer;

begin
ConsoleClose := 0
end;

{$F-}


{***}
{ Assign a file to the console }
procedure AssignCON(var F : Text);

var
  IOChain : IOFunctions;	{ Console I/O function chain }

begin
with IOChain do
  begin
  NextOpen := @ConsoleOpen;
  NextInOut := nil;
  NextFlush := @ConsoleFlush;
  NextClose := @ConsoleClose
  end;

AssignANSI(F, IOChain)
end;


{***}
{ Return true if character in keyboard buffer }
function KeyPressed : boolean;

const
  ZeroFlag =		{ Zero flag bit }
    $0040;

var
  Regs : Registers;	{ MS-DOS registers }

begin
if not KeyPending then
  begin
  { Check standard input device status }
  Regs.AH := $06;
  Regs.DL := $FF;
  MSDOS(Regs);

  KeyPending := Regs.Flags and ZeroFlag = 0;
  if KeyPending then
    PendingKey := Chr(Regs.AL)
  end;

KeyPressed := KeyPending
end;


{***}
{ Read character from standard input device }
function ReadKey : char;

var
  Regs : Registers;	{ MS-DOS registers }

begin
if KeyPending then
  KeyPending := false
else
  begin
  { Read character }
  Regs.AH := $07;
  MSDOS(Regs);

  PendingKey := Chr(Regs.AL)
  end;

if (PendingKey = BRK) and CheckBreak then
  begin
  WriteLn('^C');
  inline
  (
  $CD/$23	{ INT	23h }
  )
  end;

ReadKey := PendingKey
end;


{***}
begin
Close(Input);
Close(Output);

AssignCON(ANSIFile);
Rewrite(ANSIFile);

AssignCON(Input);
Reset(Input);

AssignCON(Output);
Rewrite(Output);

TabLength := 1
end.