UNIT OvrService ;
(****************************************************************************)
(* OVRSERVICE.PAS (Turbo Pascal 6.0 unit)                                   *)
(*$O+                                                                       *)
(* Overlay management services                                              *)
(****************************************************************************)
(* Revision history:                                                        *)
(*  18-Apr-1992 written by hs and released on CompuServe                    *)
(****************************************************************************)
(* This unit was written by Hans Schleichert at Institute of Ophthalmology, *)
(* London.                                                                  *)
(* Copyright (c) all parts Hans Schleichert, 1992.                          *)
(* This piece of software is intended for and donated to the auditory of    *)
(* Borland's programming forums on CompuServe for their private, non-       *)
(* commercial use. The term "non-commercial" means that they must not make  *)
(* financial profit with this software, or by use of it. If you intend to   *)
(* use the software for commercial purposes you are required to ask the     *)
(* author's permission BEFORE you do so.                                    *)
(* Neither the author nor anyone else can take responsibility for the       *)
(* software being error-free. The author shall not be liable for any damage *)
(* or loss resultant from the use of the software.                          *)
(****************************************************************************)
(* Contacting the author:                                                   *)
(*  Send a CISMail message to Hans Schleichert, [100031,775]. Your comments *)
(*  are always welcome.                                                     *)
(****************************************************************************)
(* Further reading recommended:                                             *)
(*  For more about overlays, download the files OVRLAY.TXT and OVROBJ.ZIP   *)
(*  from the BPROGA forum's libraries. Thanks to Ron Schuster (CompuServe   *)
(*  [76666,2322]) who wrote and uploaded those files.                       *)
(****************************************************************************)

(****************************************************************************)
(*************************************) INTERFACE (**************************)
(****************************************************************************)

    TYPE    (************************** overlay header record ***************)
        POvrHeader = ^TOvrHeader ;
        TOvrHeader = RECORD
            Signature, SaveReturn : Word ;
            FilePos : LongInt ;
            CodeSize, FixupSize, JumpCount, Link, Segment, RetryCount, Next,
            EmsPage, EmsOffset : Word ;
            UserData : ARRAY [0..2] OF Word ;
            Vectors : RECORD END ;
        END ;

    FUNCTION OvrGetAddress (P : Pointer) : Pointer ;
    (* checks whether an address P points into overlaid code or not,    *)
    (* and returns a pointer into the overlay header if possible.       *)
    (* Input:                                                           *)
    (*  P       a pointer into some executable program code             *)
    (* Returns:                                                         *)
    (*  NIL     if P does not point into overlaid code                  *)
    (*  Seg:Ofs where Seg is the is the segment part of the address of  *)
    (*          the overlay header for the segment P points to, and Ofs *)
    (*          is the offset part of P if P points to overlaid code    *)
    (*  Seg:Ofs where Seg is the segment part of P and Ofs is the       *)
    (*          return offset saved in the overlay record pointed to by *)
    (*          P if P points to a saved return in an overlay header    *)
    (* Notes:                                                           *)
    (*  1 - If return value is NIL, P points into a non-verlaid part of *)
    (*      the program.                                                *)
    (*  2 - The third case (P pointing to an overlay header) is mean-   *)
    (*      ingful because P may contain a subroutine's return address  *)
    (*      to a swapped-out module. In this case, P will take the form *)
    (*      (segment of overlay header):0. When the calling routine     *)
    (*      wants to learn about the caller's address, it should pass   *)
    (*      the DWORD at [BP+4] as an argument to OvrGetAddress.        *)
    (********************************************************************)

    FUNCTION IsOverlaid (Segment : Word) : Word ; (**********************)
    (* checks whether an address is in an overlaid segment or not       *)
    (* Input:                                                           *)
    (*  Segment     Segment part of the address to check                *)
    (* Returns:                                                         *)
    (*  True        if the address is in an overlaid segment            *)
    (*  False       if not                                              *)
    (* Note:                                                            *)
    (*  This function works whether Segment points to the actual code   *)
    (*  or to the overlay header.                                       *)
    (********************************************************************)

(****************************************************************************)
(*************************************) IMPLEMENTATION (*********************)
(****************************************************************************)

    FUNCTION OvrGetAddress (P : Pointer) : Pointer ; ASSEMBLER ;

        ASM
            MOV     AX,[Word PTR P+0]
            MOV     BX,[Word PTR P+2]
            MOV     DX,[OvrLoadList]    (* check load list                  *)
            MOV     DI,TOvrHeader.Segment
@@1:        OR      DX,DX               (* last entry?                      *)
            JZ      @@2                 (* yes, go to code list             *)
            MOV     ES,DX
            CMP     [ES:DI],BX          (* this segment?                    *)
            JE      @Done               (* yes, exit                        *)
            MOV     DX,[(TOvrHeader PTR ES:DI - TOvrHeader.Segment).Next]
            JMP     @@1

@@2:        XOR     DX,DX               (* not deepest return to swapped-   *)
            OR      AX,AX               (* out overlay or maybe no overlay  *)
            JNZ     @NoOvl              (* at all? yes, exit                *)

            MOV     CX,[PrefixSeg]      (* code list segments are relative  *)
            ADD     CX,10h
            MOV     DX,[OvrCodeList]    (* check code list                  *)
            MOV     DI,TOvrHeader.Link
@@3:        OR      DX,DX               (* last entry?                      *)
            JZ      @NoOvl              (* yes, exit                        *)
            ADD     DX,CX               (* add relative segmet base         *)
            CMP     DX,BX               (* this segment?                    *)
            MOV     ES,DX               (* no, check next                   *)
            JE      @@4                 (* yes, exit                        *)
            MOV     DX,[ES:DI]
            JMP     @@3
@@4:        MOV     AX,[(TOvrHeader PTR ES:DI - TOvrHeader.Link).SaveReturn]
                                        (* load saved return address        *)
            JMP     @Done

@NoOvl:     XOR     AX,AX               (* not overlaid, return NIL         *)
            XOR     DX,DX

@Done:  END ;

    FUNCTION IsOverlaid (Segment : Word) : Word ; ASSEMBLER ;

        ASM
            MOV     BX,[OvrLoadList]
            MOV     DI,TOvrHeader.Segment
            MOV     DX,[Segment]
@@1:        OR      BX,BX
            JZ      @@2
            MOV     ES,BX
            CMP     [ES:DI],DX
            JE      @Done
            MOV     BX,[(TOvrHeader PTR ES:DI).Next - TOvrHeader.Segment]
            JMP     @@1
@@2:        MOV     CX,[PrefixSeg]
            ADD     CX,10h
            MOV     BX,[OvrCodeList]
            MOV     DI,TOvrHeader.Link
@@3:        OR      BX,BX
            JZ      @Done
            ADD     BX,CX
            CMP     BX,DX
            JE      @Done
            MOV     ES,BX
            MOV     BX,[ES:DI]
            JMP     @@3
@Done:      MOV     AX,BX
        END ;

END .