(******************************************************************************)
(*                              PROGRAM DRVDEMO                               *)
(*                                                                            *)
(*                               Version: 3.13                                *)
(*                                                                            *)
(*              Copyright (C) 1991, 1992 by NativSoft Computing               *)
(*                                                                            *)
(*                              1155 College Ave                              *)
(*                              Adrian, MI 49221                              *)
(*                               (517) 265-6080                               *)
(*                              CIS [71160,1045]                              *)
(*                                                                            *)
(*                             ALL RIGHTS RESERVED                            *)
(******************************************************************************)

(******************************************************************************)
(*      Written by:  Charles B. Little, Ph.D.                                 *)
(*         Version:  3.13                                                     *)
(*   Revision Date:  28 March 1992                                            *)
(*         Purpose:  To demonstrate the use of unit DRIVExx - ver 3.13 - to   *)
(*                   obtain important information about disk drives.          *)
(******************************************************************************)

{$S-,R-}

PROGRAM DRVDEMO;

USES DOS, CRT, DRIVExx;

{$I drvdemo.inc}

var index : char;
    X     : longint;
    DP    : fakeDPB;
    G     : word;

BEGIN
  clrscr;
  if DriveError <> 0 then
  begin
    ShowDriveError;
    clrscr;
  end;

  Openingscreen;

  for index := 'A' to chr($60) do    { $5B thru $60 are for Novell drives }
  begin
    positioncursor;
    if DrivExists(index) then
    begin
      writeln;writeln(index,':');
      write('BIOS #',ShowBIOSDriveNum(index),', ');
      if DriveisNormal(index) then
      begin
        write('normal:');
        if DriveisRemovable(index) then
        begin
          write(' removable');
          case RemovableDrivetype(index) of
          -3,-2,-1 :  write(', Drivetype error ',RemovableDrivetype(index));
           1 :  write(', 5.25" DD');
           2 :  write(', 5.25" HD');
           3 :  write(', 3.5" DD');
           4 :  write(', 3.5" HD');
           5 :  write(', 3.5" QD');
           6 :  write(', Tape');
           7 :  write(', Bernoulli');
           else write(', type = ?');
          end; {case}
          if ChangeLineSupported(index) then
            if DiskWasChanged(index) then write(', changed')
            else write(', not changed');
        end
        else
        begin
          if DriveisHard(index) then write(' hard');
          if DriveisRAMDisk(index) then write(' RAMDisk');
          if DriveisOtherfixed(index) then write(' unknown fixed');
        end;
        X := DiskSyze(index);
        {can't use LONGINT variables as selectors in case statements, so we
         must handle DiskSyze in a less than elegant way}
        if (X = -1) then write(', size = error')
        else
          if (X = 0) then write(', size = ?')
          else
            write(', size = ',X);
        if (DriveMappedTo(index) <> index) then
          write(', attached to ',DriveMappedTo(index),':');

      end {driveisnormal}
      else
      begin
        write('abnormal:');
        if DriveisPhantom(index) then
          write(' phantom, mapped to ',DriveMappedTo(index),':');
        if DriveisNONDOS(index) then write(' NON-DOS');
        if DriveisAliased(index) then
        begin
          if DRDOS then write(' aliased')
          { DRDOS reports SUBST when *either* ASSIGN or SUBST is used.  Since
            we cannot verify that NETWORK and IFS will be reported correctly
            under DRDOS, we recommend that the generic "aliased" be used to
            classify ALL of these situations below when running under that OS }
          else
          begin
            if DriveisJoined(index) then write(' joined');
            if DriveisSubsted(index) then write(' substituted');
            if DriveisAssigned(index) then
                write(' assigned to ',DriveMappedTo(index),':');
            if DriveisNetwork(index) then write(' network');
            if DriveisIFS(index) then write(' IFS');
          end;
        end;
      end; {driveisabnormal}

      {the following apply to all drives, normal or abnormal}

      if DevDrvrChainValid then
      begin
        if DriveisDeviceDriven(index) then write(', device driven');
        if DriveisSwapped(index) then write(', swapped with ',SwappedWith(index));
        writeln;
      end;
      if (not NetWareLoaded) then
       writeln('Logged Directory is ',CurrentDir(index));
    end; {if drivexists}
  end; {for index := 'A' to ''' do}


  writeln;writeln;
  write('Enter a drive letter to demonstrate function GETDPB ');
  index := readkey;
  if (not drivexists(index)) and (not driveisnormal(index)) then halt;
  clrscr;

  G := GETDPB(index,DP,false);
  if (G = 0) then {FALSE means don't hit the disk}
  begin
    writeln;
    writeln('Drive ',upcase(index),': DPB data in memory');
    showdpbdata(DP);
  end
  else
  begin
    writeln;
    writeln('Drive ',upcase(index),': access failed or drive invalid.  Error ',hi(G),':',lo(G));
    halt;
  end;


  write('Press ENTER to get *NEW* DPB data');
  readln;clrscr;

  G := GETDPB(index,DP,true);
  if (G = 0) then {TRUE means hit the disk}
  begin
    writeln;
    writeln('Drive ',upcase(index),': DPB data from direct disk access');
    showdpbdata(DP);
  end
  else
  begin
    writeln;
    writeln('Drive ',upcase(index),': access failed or drive invalid.  Error ',hi(G),':',lo(G));
    halt;
  end;
END.