CONST
		
D_NAMSZ      = 16 ; { Length of a name }


	{ User account structure }

TYPE 

        DWORD = Record
          HiWord : Word;
          LoWord : Word;
        END;

        user_account = RECORD
        
	UA_name                         : Array[00..(D_NAMSZ-1)] of Char;		{ Zero padded username }
	UA_internal                     : Array[00..(D_NAMSZ-1)] of Char;		
        UA_description                  : Array[00..31]          of Char;		{ Full user description }
	UA_privilege                    : Byte;		{ Privilege bits  }
										{ (see definitions below) }
	UA_concurrent                   : Byte;		{ Maximum concurrent log ins }
	UA_allowed_times                : Array[00..41] of Byte;		{ 1 bit for each half hour for 7  }
										{ days. Week begins Sunday. }
										{ 0 means allowed. }
	UA_internal2                    : Word;
	UA_last_login_time              : Array[00..01] of Word;		{ Last time logged in }
	UA_account_expiration           : Array[00..01] of Word; 	{ Expiration date (MSDOS-format) }
										{ Year, Month:Day }
	UA_password_expiration          : Array[00..01] of Word;	{ Expiration date (as above) }
										{ 0 means no expiration date. }
	UA_password_extension           : Byte;		{ 1-31  Number of days to reextend }
										{ password after change, 0 says no  }
										{ extension required }
	UA_undelete_char                : Byte;			{ First letter of UA_name when   }
										{ account is deleted (first  }
										{ character of UA_name is replaced  }
										{ with a zero.) }
	UA_xprivilege                   : Byte;				{ Extended privilege }
	UA_future                       : Array[00..02] of Byte;		

        END;

	{ Privilege bits for UA_privilege: }
CONST

UA_privilege_superACL	 = $80;	{ Bypass ACLs }
UA_privilege_superqueue  = $40;	{ Bypass queue protection }
UA_privilege_peer        = $20;	{ Treat as local process }
UA_privilege_supermail   = $10;	{ Bypass mail protection }
UA_privilege_audit       = $08;	{ User can create audit entries }
UA_privilege_system      = $04;	{ User has system manager privileges }
UA_xprivilege_nopwchange = $01;   { User cannot change password }

MB_textlen	         = 80;					{ Length of message text buffer }

TYPE										{ Message buffer structure }
        message_buffer	 = RECORD

	MB_reserved             : Byte;				{ Reserved field used by system call }
	MB_type                 : Byte;					{ User defined message type  }
										{ (see below) }
	MB_machine              : Array[00..(D_NAMSZ-1)] of Char;		{ Machine name destination }
	MB_server               : Array[00..(D_NAMSZ-1)] of Char;		{ User must be logged into this }
										{ server }
	MB_user                 : Array[00..(D_NAMSZ-1)] of Char;			{ User must be using this username }
	MB_originator           : Array[00..(D_NAMSZ-1)] of Char;	{ Originator's machine name.  }
										{ Filled when message is received }
	MB_text                 : Array[00..(MB_textlen-1)] of Char;		{ Message text }

        END;

	{ Message buffer type.   }

CONST

MBT_general	= 0;					{ General msg used by NET and others }
MBT_warning	= 1;					{ Server warning message }

	{ Message service disposition }

MPB_beep		= $01;			{ Beep before delivering message }
MPB_deliver		= $02;			{ Deliver to message service }
MPB_auto_pop_up	        = $04;			{ Pop up messages automatically }

	{ Definition of a queue entry: }

TYPE

        queue_entry = RECORD
        
	QE_status                       : Byte;					{ Status of queue entry }
	QE_size                         : DWORD;					{ Size of spooled file }
	QE_type                         : Byte;					{ Type of queue entry }
	QE_output_control               : Byte;			{ Control of despooled file }
	QE_copies                       : Word;					{ Number of copies }
	QE_sequence                     : DWORD;				{ Sequence number of queue entry }
	QE_spooled_file                 : Array[00..47] of Char;		{ Pathname of spooled file }
	QE_user                         : Array[00..(D_NAMSZ-1)] of Char;			{ Username who spooled file }
	QE_machine                      : Array[00..(D_NAMSZ-1)] of Char;		{ Machine name user was on }
	QE_date                         : Word;					{ Date file spooled (MS-DOS format) }
	QE_time                         : Word;					{ Time file spooled (MS-DOS format) }
	QE_destination                  : Array[00..D_NAMSZ] of Char;	{ ASCIZ Device or username destn. }
	QE_comment                      : Array[00..47] of Char;				{ Comment field }

        END;


CONST
	{ Different queue entry statuses }

QE_status_free		=	0;	{ The queue entry is empty }
QE_status_update	=	1;	{ The queue entry is being updated }
QE_status_hold		=	2;	{ The queue entry is held }
QE_status_wait		=	3;	{ The queue entry is waiting for despool }
QE_status_active	=	4;	{ The queue entry is being despooled }
QE_status_cancel	=	5;	{ The queue has been canceled }
QE_status_file_error	=       6;	{ The spooled file could not be accessed }
QE_status_spool_error	=       7;	{ The destination could not be accessed }
QE_status_rush		=	8;	{ Rush this job }
	
	{ Different types of queue entries: }
	
QE_type_print		=       0;	{ Spooled printer queue file }
QE_type_message		=       1;	{ Spooled message (mail) }
QE_type_local_file	=       2;	{ Spooled local file }
QE_type_remote_file	=       3;	{ Spooled remote file }
QE_type_modem		=       4;	{ Spooled to remote modem }
QE_type_batch		=       5;	{ Spooled batch processor file }

	{ Definitions for output control: }

QE_OC_keep	        = $40;	{ Keep after despooling (don't delete) }
							{ Used for mail - allow delete only by owner }

	{ Definitions for mail }

QE_OC_voice	 	= $20;	{ Mail file contains voice data }
QE_OC_opened 		= $10;	{ Message has been read }
QE_OC_request_response 	= $04;	{ Response requested }

	{ Control queue commands. }

CQ_start			= 0;	{ Start despooling }
CQ_halt				= 1;	{ Halt despooling }
CQ_halt_EOJ			= 2;	{ Halt despooling at end of job }
CQ_pause			= 3;	{ Pause the despooler at end of job }
CQ_single			= 4;	{ Print single job }
CQ_restart			= 5;	{ Restart the current print job }
CQ_cancel			= 6;	{ Cancel the currently printing job }
CQ_hold				= 7;	{ Hold the queue entry }
CQ_release			= 8;	{ Release a held queue entry }
CQ_rush				= 9;	{ Make the queue entry a rushed job }

TYPE

	{ Definition of printer states: }

        printer_state = RECORD
        
	PS_state_pause                 : Byte;	{ Set 1 when printer paused }
	PS_state_value                 : Byte;	{ Set to PS_state_ value (see below) }

        END;

CONST

PS_state_disabled	= 0;	{ Printer is disabled }
PS_state_single_job	= 1;	{ Printer will stop at end of job }
PS_state_multijob	= 2;	{ Printer should print multiple jobs }

TYPE
	{ Definition of a printer status entry: }

        PS  = RECORD
							{ Printer state }
	PS_state        : Byte;
	PS_index        : Word;		{ Queue index corresponding to print job  }
							{ being despooled. -1 if not despooling. }
	PS_CPS          : Word;			{ Actual characters per second being output }
	PS_output_chars : DWORD; { Characters actually output so far }
	PS_read_chars	: DWORD; { Characters actually read from despooled  }
							{ file so far. May be used to compute  }
							{ percent completed. }
	PS_copies        : Word;		{ Copies remaining to print }

        END;

	{ Definition of logical stream entry: }

        logical_stream = RECORD
        
	LS_queue                : Byte;	        	{ 0 Disabled, non-zero Enabled }
	LS_template             : Array[00..12] of Char;{ Template may contain ?'s (include "." as  }
							{ in @???????.???) }
        END;

	{ Definition of active user entry: }

        active_user_entry = RECORD
        
	AUE_VCID                : Word;				{ Virtual circuit number }
	AUE_state               : Byte;				{ Login state (defined below) }
	AUE_command             : Byte;	   		{ Last command issued }
	AUE_IO                  : Array[00..04] of Byte;				{ Number of I/O bytes (40 bit number) }
	AUE_requests            : Array[00..02] of Byte;		{ Number of server requests (24 bits) }
	AUE_name                : Array[00..(D_NAMSZ-1)] of Char;		{ Name of logged in user }
	AUE_machine             : Array[00..(D_NAMSZ-1)] of Char;	{ Name of remote logged in machine }
	AUE_xprivilege          : Byte;			{ Extended privileges }
	AUE_time_left           : Word;			{ Time left in minutes }

        END;

CONST

	{ Definition of the various login states and privileges: }

AUE_state_starting	 	= $00;	{ We are in the middle of login }
AUE_state_in		 	= $01;	{ We are fully logged in }
AUE_state_RPL		 	= $02;	{ Remote program load login }

AUE_privilege_superACL	 	= $80;	{ Bypass ACLs }
AUE_privilege_superqueue	= $40;	{ Bypass queue protection }
AUE_privilege_peer       	= $20;	{ Treat as local process }
AUE_privilege_supermail  	= $10;	{ Bypass mail protection }
AUE_privilege_audit      	= $08;	{ User can create audit entries }
AUE_privilege_system     	= $04;	{ User has system manager privs }
AUE_xprivilege_nopwchange	= $01;	{ User cannot change his password }

	{ Active user entry commands: }

AUEC_login			= 0;	{ Login into a server }
AUEC_terminate			= 1;	{ Process termination }
AUEC_open			= 2;	{ Open a file }
AUEC_close			= 3;	{ Close a file }
AUEC_create			= 4;	{ Create a file if it's there or not }
AUEC_new			= 5;	{ Create a new file that is not there }
AUEC_unique			= 6;	{ Create a unique file }
AUEC_commit			= 7;	{ Commit disk data to disk }
AUEC_read			= 8;	{ Read from file }
AUEC_write			= 9;	{ Write to file }
AUEC_delete			= 10;	{ Delete file }
AUEC_set_attr			= 11;	{ Set file attributes }
AUEC_lock			= 12;	{ Lock byte range }
AUEC_unlock			= 13;	{ Unlock byte range }
AUEC_create_dir			= 14;	{ Create a subdirectory }
AUEC_delete_dir			= 15;	{ Delete a subdirectory }
AUEC_rename_file		= 16;	{ Rename a file }
AUEC_find_first			= 17;	{ Find first matching file }
AUEC_find_next			= 18;	{ Find the next matching file }
AUEC_disk_free			= 19;	{ Get disk free space }
AUEC_get_queue			= 20;	{ Get a queue entry }
AUEC_set_queue			= 21;	{ Set a queue entry }
AUEC_control_queue		= 22;	{ Control the queue }
AUEC_get_login			= 23;	{ Return login information }
AUEC_get_link			= 24;	{ Return link description }
AUEC_seek			= 25;	{ Seek to a file position }
AUEC_get_time			= 26;	{ Get server's time }
AUEC_audit			= 27;	{ Create audit entry }
AUEC_multi_open			= 28;	{ Open file in a multitude of modes }
AUEC_change_password	        = 29;	{ Change a password }
AUEC_disable_account	        = 30;	{ Disable account from further log ins }
AUEC_copy_file			= 31;	{ Local server file copy }
AUEC_get_username		= 32;	{ Get a username from account file }
AUEC_translate_path		= 33;	{ Translate a server's logical path }
AUEC_create_indirect	        = 34;	{ Make indirect file }
AUEC_get_indirect		= 35;	{ Get indirect file text }
AUEC_printer_status		= 36;	{ Printer status obtained }
AUEC_get_stream			= 37;	{ Get logical print stream information }
AUEC_set_stream			= 38;	{ Set logical print stream information }
AUEC_get_account		= 39;	{ Get an account record }
AUEC_shutdown			= 40;	{ Request server shutdown }
AUEC_cancel_shutdown	        = 41;	{ Cancel server shutdown }
AUEC_stuff			= 42;	{ Stuff server keyboard }
AUEC_write_with_commit	        = 43;	{ Commit data to disk }

	{ ACL bit definition: }

ACL_read		= $8000;	{ (R) Allow reading }
ACL_write		= $4000;	{ (W) Allow writing }
ACL_create_file         = $2000;	{ (C) Allow file creation }
ACL_create_dir          = $1000;	{ (M) Allow directory creation }
ACL_lookup              = $0800;	{ (L) Allow lookups }
ACL_delete_file	        = $0400;	{ (D) Allow file deletion }
ACL_delete_dir          = $0200;	{ (K) Allow directory deletion }
ACL_rename              = $0100;	{ (N) Allow file renaming }
ACL_execute             = $0080;	{ (E) Allow program execution }
ACL_physical            = $0040;	{ (P) Allow physical access }
ACL_attribute           = $0020;	{ (A) Allow attribute changing }
ACL_indirect	        = $0010;	{ (I) Allow indirect file expansion }

TYPE
	{ Definition of time buffer: }

        time_block = RECORD
        
	TB_year                 : Word;		{ Year }
	TB_day                  : Byte;		{ Day of month (1-31) }
	TB_month                : Byte;		{ Month (1-12) }
	TB_minutes              : Byte;		{ Minutes (0-59) }
	TB_hour                 : Byte;		{ Hour (0-23) }
	TB_hundredths           : Byte;	        { Hundredths of seconds (0-99) }
	TB_seconds              : Byte;		{ Seconds (0-59) }
        
        END;


CONST

	{ Definition of server shutdown option flags }

SHUTDOWN_option_reboot		= $0001;        { Reboot after shutdown }
SHUTDOWN_option_silent		= $0002;	{ Do not notify users }
SHUTDOWN_option_halt		= $0004;	{ Halt after shutdown }
SHUTDOWN_option_powerfail	= $0008;	{ Shutdown due to power fail }
											{ (Used by UPS.) }
SHUTDOWN_option_reserved1	= $0010;	{ RESERVED }
SHUTDOWN_option_reserved2	= $0020;
SHUTDOWN_option_reserved3	= $0040;
SHUTDOWN_option_reserved4	= $0080;
SHUTDOWN_option_user1		= $0100;	{ User definable }
SHUTDOWN_option_user2		= $0200;
SHUTDOWN_option_user3		= $0400;
SHUTDOWN_option_user4		= $0800;
SHUTDOWN_option_user5		= $1000;
SHUTDOWN_option_user6		= $2000;
SHUTDOWN_option_user7		= $4000;
SHUTDOWN_option_reserved5	= $8000;	{ RESERVED }

