Unit InvTrig;

Interface

Function InvSin(X : Real) : Real;
Function InvCos(X : Real) : Real;
Function InvTan(X : Real) : Real;

Implementation

Function InvSin(X : Real) : Real;
Begin
  If Abs(X) = 1.0 Then
     X := Pi/2.0
  Else
     X := ArcTan(X/Sqrt(1-X*X));
X := X*180/Pi;
InvSin := X;
End;

Function InvCos(X : Real) : Real;
Begin
  If Abs(X) = 0.0 Then
     X := Pi/2.0
  Else
     X := ArcTan(Sqrt(1-X*X)/X);
IF X<0.0 Then X := X+Pi;
X := X*180/Pi;
InvCos := X;
End;

Function InvTan(X : Real) : Real;
Begin
X := ArcTan(X);
X := X*180/Pi;
InvTan := X;
End;

End.
