
(**********************************************************************)
(* Simple program to demonstrate how to use the FlxKey unit to obtain *)
(* user-data from encrypted registration-key file.                    *)
(**********************************************************************)

program ReadFlxKeyDemo1;
uses
  Crt,
  FlxKey;

var           (* Variable set by ReadFlxKey routine, that indicates   *)
              (* the difference in days between the current date and  *)
              (* the date encrypted into the registration-key file.   *)
  DaysOld,

              (* This variable is used to check for errors returned   *)
              (* by ReadFlxKey routine.                               *)
  ErrorCode : word;

              (* Encryption-code strings used to create encrypted     *)
              (* registration-key file.                               *)
  Ecode1,
  Ecode2 : st100;

              (* This is the full path/filename of the encrypted      *)
              (* registration-key file to be decrypted.               *)
  RegKeyName : st79;

              (* Record variable to hold the data decrypted from the  *)
              (* encrypted registration-key file.                     *)
  TempKeyRec : FlxRec;

              (* Main program execution block.                        *)
BEGIN
              (* Clear the temporary key-record variable.             *)
  fillchar(TempKeyRec, sizeof(TempKeyRec), 0);

              (* Assign encryption-code strings to be used to decrypt *)
              (* encrypted registration-key data.                     *)
  Ecode1 := 'Apple';
  Ecode2 := 'Orange';

              (* Full path/filename for the encrypted registration-   *)
              (* key file to be decrypted.                            *)
  RegKeyName := 'DEMO1.KEY';

              (* Decrypt the registration-key file, and retrieve it's *)
              (* data.                                                *)
              (* NOTE: A 10 second delay and message are present in   *)
              (*       the un-registered copy of the FlxKey unit.     *)
  ReadFlxKey(Ecode1, Ecode2, RegKeyName, TempKeyRec, DaysOld, ErrorCode);

              (* Clear the screen.                                    *)
  clrscr;
  writeln;

              (* Check for errors.                                    *)
  if (ErrorCode <> 0) then
    case (ErrorCode AND $FF) of
       1 : writeln(' Error! One or more encryption-codes are blank.');
       2 : writeln(
                ' Error! Filename for registration-key file is blank.');
       3 : writeln(' Error! Registration-key file is corrupt.');

              (* I/O error!                                           *)
      16 : begin
             writeln(' I/O error = ', (ErrorCode shr 8));

              (* Standard Turbo Pascal error-codes. See TP manuals,   *)
              (* as there are many types of errors to check for.      *)
             case (ErrorCode shr 8) of
                 2 : writeln(' File not found.');
                 3 : writeln(' Path not found.');
                 4 : writeln(' Too many files open.');
                 5 : writeln(' File access denied.');
               100 : writeln(' Disk read error.');
               103 : writeln(' File not open')
             end  (* case (ErrorCode shr 8) of                        *)
           end
    end       (* case (ErrorCode AND $FF) of                          *)
  else
              (* Else NO errors occurred.                             *)
    begin
              (* Display the decrypted registration-key data.         *)
      writeln('Key is ', DaysOld, ' days old');
      writeln;
      with TempKeyRec do
        begin
          writeln(' FirstName    = ', FirstName);
          writeln(' LastName     = ', LastName);
          writeln(' Address1     = ', Address1);
          writeln(' Address2     = ', Address2);
          writeln(' Address3     = ', Address3);
          writeln(' AppName      = ', AppName);
          writeln(' Version      = ', Version);
          writeln(' Serial Num   = ', Serial);

              (* Standard TP "UnPackTime" and "PackTime" routines     *)
              (* can be used to manipulate "packed date" data.        *)
          writeln(' Packed Date  = ', Date);

          writeln(' Access Level = ', Access)
        end
    end
END.


