
Sub AircraftOpen ()
' open aircraft file
' ------------------
   AircraftDbf = vxUseDbf("\vb\vxbtest\aircraft.dbf")
   If AircraftDbf = False Then
      MsgBox "Error Opening aircraft.dbf. Aborting."
      End
   End If
   Aircraf1Ntx = vxUseNtx("\vb\vxbtest\aircraf1.ntx")
   Aircraf2Ntx = vxUseNtx("\vb\vxbtest\aircraf2.ntx")

' Declare Aircraft Table
' ----------------------
   j% = vxSelectDbf(AircraftDbf)
   Call vxTableDeclare(VX_RED, ByVal 0&, ByVal 0&, 0, 1, 6)
   Call vxTableField(1, "Type", "c_cat", VX_FIELD)
   Call vxTableField(2, "Description", "left(c_desc,20)", VX_EXPR)
   Call vxTableField(3, "Code", "c_code", VX_FIELD)
   Call vxTableField(4, "Price", "c_price", VX_FIELD)
   Call vxTableField(5, "Year", "c_year", VX_FIELD)
   Call vxTableField(6, "TTSN", "c_ttsn", VX_FIELD)

End Sub

Sub BrowseAir ()
   ' Browse Aircraft File
   ' Called from VXFORM1 OpenAircraft_click and VXFORM6.AirBrowse
   ' ------------------------------------------------------------

   ' Select Aircraft File
   ' --------------------
   j% = vxSelectDbf(AircraftDbf)
   j% = vxSelectNtx(Aircraf2Ntx)

   ' Open a browse table no editing capabilities
   ' -------------------------------------------
   AircraftReturn = 0  ' declared as GLOBAL so VXFORM6 can interrogate

   ' Disable menu items
   ' ------------------
   VXFORM1.OpenCust.Enabled = False
   VXFORM1.OpenAircraft.Enabled = False
   VXFORM1.LinkBuyToSell.Enabled = False
   VXFORM1.LinkSellToBuy.Enabled = False
   VXFORM1.PackFiles.Enabled = False
   
   Form6Active = True  ' true so will be true when browse up

' Execute the browse routine (will use table declared in VXFORM0)
' ---------------------------------------------------------------
   Call vxBrowse(VXFORM1.hWnd, AircraftDbf, Aircraf2Ntx, False, True, False, 0, "Aircraft On File", AircraftReturn)

   Select Case AircraftReturn

      Case BROWSE_ERROR
         MsgBox "Error in AirCraft Browse!"
         VXFORM1.OpenCust.Enabled = True
         VXFORM1.OpenAircraft.Enabled = True
         VXFORM1.LinkBuyToSell.Enabled = True
         VXFORM1.LinkSellToBuy.Enabled = True
         VXFORM1.PackFiles.Enabled = True
         Form6Active = False
         Exit Sub
      
      ' user closed browse with sys menu
      ' --------------------------------
      Case BROWSE_CLOSED
         j% = vxSelectDbf(AircraftDbf)
         j% = vxClose()
         VXFORM1.OpenCust.Enabled = True
         VXFORM1.OpenAircraft.Enabled = True
         VXFORM1.LinkBuyToSell.Enabled = True
         VXFORM1.LinkSellToBuy.Enabled = True
         VXFORM1.PackFiles.Enabled = True
         Form6Active = False
         Exit Sub

      ' the only other choice is the user double-clicked
      ' a record or pressed the enter key, thereby requesting
      ' a full display on VXFORM6
      ' ------------------------------------------------------
      Case Else
         VXFORM6.Show
  
   End Select

End Sub

Sub BrowseBuyers ()
' Select Airbuyer File
' --------------------
   j% = vxSelectDbf(AirbuyerDbf)
   j% = vxSelectNtx(Airbuy1Ntx)  ' index on customer code

' Open a browse table with no onscreen full editing capabilities
' --------------------------------------------------------------
   BuyerReturn = 0  ' declared as GLOBAL so VXFORM4 can interrogate

' Execute the browse routine (will use table declared in VXFORM3)
' ---------------------------------------------------------------
   Call vxBrowse(VXFORM1.hWnd, AirbuyerDbf, Airbuy1Ntx, False, True, True, BuyerRec, "Buyer Records for " + CustKey, BuyerReturn)

   Select Case BuyerReturn

      Case BROWSE_ERROR
         MsgBox "Error in AirBuyer Browse!"
         
         ' set up return to customer form
         ' ------------------------------
         j% = vxClose()
         StatesOpen
         j% = vxSelectDbf(AircustDbf)
         VXFORM3.Show
         Exit Sub

      Case BROWSE_CLOSED
         j% = vxSelectDbf(AirbuyerDbf)
         Call vxTableReset
         j% = vxClose()
         j% = vxSelectDbf(AirTypesDbf)
         Call vxTableReset
         j% = vxClose()
         StatesOpen
         j% = vxSelectDbf(AircustDbf)
         j% = vxSelectNtx(Aircust1Ntx)
         j% = vxSeek(CustKey)
         CustReturn = BROWSE_EDIT
         VXFORM3.Show

      ' other choices are processed by VXFORM4
      ' ------------------------------------------
      Case Else
         VXFORM4.Show
   End Select
End Sub

' Browse customer file
' called from VXFORM1 OpenCust_Click and VXFORM3.CustBrowse
' ---------------------------------------------------------
Sub BrowseCust ()

   ' Select Aircust File
   ' --------------------
   j% = vxSelectDbf(AircustDbf)
   j% = vxSelectNtx(Aircust1Ntx)  ' index on customer code

   ' Open a browse table with no onscreen full editing capabilities
   ' --------------------------------------------------------------
   CustReturn = 0  ' declared as GLOBAL so VXFORM3 can interrogate

   ' Disable all menu items because this
   ' module uses all other files and we don't want to
   ' interfere with its operation
   ' ------------------------------------------------
   VXFORM1.OpenTypes.Enabled = False
   VXFORM1.OpenCust.Enabled = False
   VXFORM1.OpenAircraft.Enabled = False
   VXFORM1.LinkBuyToSell.Enabled = False
   VXFORM1.LinkSellToBuy.Enabled = False
   VXFORM1.PackFiles.Enabled = False
   VXFORM1.TestCreate.Enabled = False
   VXFORM1.TestCopy.Enabled = False
   VXFORM1.TestDataCopy.Enabled = False
   VXFORM1.FileStruc.Enabled = False

   Form3Active = True  ' true so will be true when browse up

   ' Execute the browse routine (will use table declared in VXFORM0)
   ' ---------------------------------------------------------------
   TStartRec& = 0
   Call vxBrowse(VXFORM1.hWnd, AircustDbf, Aircust1Ntx, False, True, True, TStartRec&, "Customers", CustReturn)

   ' Browse returns a code or record number in CustReturn var.
   ' If an edit menu item is selected, a code is returned.
   ' If the enter key is pressed, the record number is returned.
   ' Double clicks when EditMode is true allow user to edit onscreen.
   ' (return codes defined in global vxbase.txt). In this case,
   ' the EditMode% param is set to FALSE because we have data in
   ' the record that must be properly verified. The onscreen edit
   ' simply blasts the new data into the field and only checks it
   ' for type (Numeric fields must have numbers, etc.).
   ' ----------------------------------------------------------------
  Select Case CustReturn
      Case BROWSE_ERROR
         MsgBox "Error in AirCust Browse!"
         VXFORM1.OpenTypes.Enabled = True
         VXFORM1.OpenCust.Enabled = True
         VXFORM1.OpenAircraft.Enabled = True
         VXFORM1.LinkBuyToSell.Enabled = True
         VXFORM1.LinkSellToBuy.Enabled = True
         VXFORM1.PackFiles.Enabled = True
         VXFORM1.TestCreate.Enabled = True
         VXFORM1.TestCopy.Enabled = True
         VXFORM1.TestDataCopy.Enabled = True
         VXFORM1.FileStruc.Enabled = True
         Form3Active = False
         Exit Sub
      
      ' user closed browse with sys menu
      ' --------------------------------
      Case BROWSE_CLOSED
         j% = vxSelectDbf(AircustDbf)
         j% = vxClose()
         j% = vxSelectDbf(AirstateDbf)
         j% = vxClose()
         VXFORM1.OpenTypes.Enabled = True
         VXFORM1.OpenCust.Enabled = True
         VXFORM1.OpenAircraft.Enabled = True
         VXFORM1.LinkBuyToSell.Enabled = True
         VXFORM1.LinkSellToBuy.Enabled = True
         VXFORM1.PackFiles.Enabled = True
         VXFORM1.TestCreate.Enabled = True
         VXFORM1.TestCopy.Enabled = True
         VXFORM1.TestDataCopy.Enabled = True
         VXFORM1.FileStruc.Enabled = True
         Form3Active = False
         Exit Sub

      ' all other choices are processed by VXFORM3
      ' ------------------------------------------
      Case Else
         VXFORM3.Show
  
   End Select
End Sub

Sub BrowseTypes ()
   ' Browse Aircraft Types File
   ' Called from VXFORM1 OpenTypes_click and VXFORM2.TypeBrowse
   ' ----------------------------------------------------------

   ' Select Airtypes File
   ' --------------------
   j% = vxSelectDbf(AirTypesDbf)
   j% = vxSelectNtx(AirtypesNtx)

   ' Open a browse table with full editing capabilities
   ' --------------------------------------------------
   TypeReturn = 0  ' declared as GLOBAL so VXFORM2 can interrogate

   ' disable menu items
   ' ------------------
   VXFORM1.OpenTypes.Enabled = False
   VXFORM1.OpenCust.Enabled = False
   VXFORM1.PackFiles.Enabled = False
   VXFORM1.TestCreate.Enabled = False
   VXFORM1.TestCopy.Enabled = False
   VXFORM1.TestDataCopy.Enabled = False

   Form2Active = True  ' true so will be true when browse up

   ' Execute the browse routine (will use table declared in TypesOpen)
   ' -----------------------------------------------------------------
   TStartRec& = 0
   Call vxBrowse(VXFORM1.hWnd, AirTypesDbf, AirtypesNtx, True, True, True, TStartRec&, "Aircraft Types", TypeReturn)
   
   ' Browse returns a code or record number in TypeReturn var.
   ' If an edit menu item is selected, a code is returned.
   ' If the enter key is pressed, the record number is returned.
   ' Double clicks when EditMode is true allow user to edit onscreen.
   ' (return codes defined in global vxbase.txt)
   ' ----------------------------------------------------------------
   Select Case TypeReturn

      Case BROWSE_ERROR
         MsgBox "Error in AirTypes Browse!"
         VXFORM1.OpenTypes.Enabled = True
         VXFORM1.OpenCust.Enabled = True
         VXFORM1.PackFiles.Enabled = True
         VXFORM1.TestCreate.Enabled = True
         VXFORM1.TestCopy.Enabled = True
         VXFORM1.TestDataCopy.Enabled = True
         Form2Active = False
         Exit Sub
      
      ' user closed browse with sys menu
      ' --------------------------------
      Case BROWSE_CLOSED
         j% = vxSelectDbf(AirTypesDbf)
         j% = vxClose()
         VXFORM1.OpenTypes.Enabled = True
         VXFORM1.OpenCust.Enabled = True
         VXFORM1.PackFiles.Enabled = True
         VXFORM1.TestCreate.Enabled = True
         VXFORM1.TestCopy.Enabled = True
         VXFORM1.TestDataCopy.Enabled = True
         Form2Active = False
         Exit Sub

      ' all other choices are processed by VXFORM2
      ' ------------------------------------------
      Case Else
         VXFORM2.Show
  
   End Select
End Sub

Sub BuyerOpen ()
   AirbuyerDbf = vxUseDbf("\vb\vxbtest\airbuyer.dbf")
   Airbuy1Ntx = vxUseNtx("\vb\vxbtest\airbuy1.ntx")
   Airbuy2Ntx = vxUseNtx("\vb\vxbtest\airbuy2.ntx")
End Sub

Sub CursorArrow ()
   hinst% = 0
   ctype& = IDC_ARROW
   hcr% = LoadCursor(hinst%, ctype&)
   j% = SetCursor(hcr%)
End Sub

Sub CursorWait ()
   hinst% = 0
   ctype& = IDC_WAIT
   hcr% = LoadCursor(hinst%, ctype&)
   j% = SetCursor(hcr%)
End Sub

Function EmptyString (TestString As String) As Integer
   EmptyString = True
   If Len(TestString) = 0 Then Exit Function
   
   For i% = 1 To Len(TestString)
      If Mid$(TestString, i%, 1) <> Chr$(32) Then
         EmptyString = False
         Exit For
      End If
   Next

End Function

Sub ProcessError ()
   ' The vxBase error structure is defined
   ' in the Global module. A Global type
   ' vxError is also defined that is filled
   ' by the vxErrorTest function.

   ' This procedure is called from the TypesOpen
   ' Sub in this module. There is an intentional
   ' file open error created in TypesOpen to
   ' illustrate the vxBase alternate error method.
   
   ' processes vxBase alternate error messages
   ' -----------------------------------------
   Select Case vxError.ErrorNum
      ' 620 File Open
      Case 620
         MsgBox "vxBase INTENTIONAL error" + Chr$(13) + Chr$(10) + "Opening File " + RTrim$(vxError.BadParm)
      Case Else
         MsgBox vxError.ErrorMsg
   End Select

   ' see Appendix A in the vxBase manual
   ' for a description of all errors

   ' identify what you feel are catastrophic
   ' errors (like a 620 error) and abort
   ' the program run entirely with an END
   ' statement
   
End Sub

Sub StatesOpen ()

' open state abbreviations file
' -----------------------------
   AirstateDbf = vxUseDbf("\vb\vxbtest\airstate.dbf")
   If AirstateDbf = False Then
      MsgBox "Error Opening airstate.dbf. Aborting."
      End
   End If
   Airstat1Ntx = vxUseNtx("\vb\vxbtest\airstat1.ntx")
   Airstat2Ntx = vxUseNtx("\vb\vxbtest\airstat2.ntx")

' Declare table used in help function
' -----------------------------------
   Call vxTableDeclare(VX_BLUE, ByVal 0&, ByVal 0&, 0, 1, 2)
   Call vxTableField(1, "Code", "statecode", VX_FIELD)
   Call vxTableField(2, "Name", "statename", VX_FIELD)

End Sub

Sub TypesOpen ()
' Open aircraft types file
' ------------------------
   AirTypesDbf% = vxUseDbf("\vb\vxbtest\airtypes.dbf")
   
   If AirTypesDbf% = False Then
      MsgBox "Error opening airtypes.dbf. Aborting."
      Exit Sub
   End If
   
   AirtypesNtx = vxUseNtx("\vb\vxbtest\airtypes.ntx")
   If AirtypesNtx = False Then
      MsgBox "Error Opening airtypes.ntx. Aborting."
      j% = vxClose()
      Exit Sub
   End If

   ' test alternate error method
   ' ---------------------------
   ' the error generated beolow is an intentional
   ' error to illustrate how the alternate
   ' error method works.

   ' VB 2.0 uses the standard VB On Error method
   ' -------------------------------------------
   On Error GoTo VBErrorRtn
   Call vxSetErrorMethod(True)
   jj% = vxUseNtx("\vb\vxbtest\testerr.ntx")

   ' VB 1.0 would not set On Error. Instead,
   ' the following code would follow the vxBase
   ' call that might result in an error
   ' ------------------------------------------
   'If vxErrorTest(vxError) Then
   '   ProcessError
   'End If
   ' ------------------------------------------

   Call vxSetErrorMethod(False)

   j% = vxSelectNtx(AirtypesNtx)

' Declare types table to get nice headings
' (TableDeclare works on currently selected DBF)
' ----------------------------------------------
   Call vxTableDeclare(VX_RED, ByVal 0&, ByVal 0&, 0, 1, 2)
   Call vxTableField(1, "Type", "category", VX_FIELD)
   Call vxTableField(2, "Description", "catname", VX_FIELD)

   Call vxFilter(".NOT. deleted()")
   Exit Sub

VBErrorRtn:
   Debug.Print Err
   MsgBox "vxBase error encountered"
   If vxErrorTest(vxError) Then
      ProcessError
   End If

   Resume Next

End Sub

