***************************************************************************
*
* Procedure file: GSXDEMO.PRG
*         System: GenScrnX
*        Version: 1.2
*         Author: Ken R. Levy
*        Company: Jet Propulsion Laboratory
*      Copyright: None (Public Domain)
*
***************************************************************************
*
* GSXDEMO - Build project LIBRARY.PJX, SAMPLE.PJX and execute README.SPR.
*
PARAMETERS m.build_all
PRIVATE m.build_all,m.lastselect,m.lastdefault,m.progpath

SET MESSAGE TO
ACTIVATE SCREEN
CLEAR
IF .NOT._DOS
  WAIT 'This program requires FoxPro for MS-DOS' WINDOW NOWAIT
  RETURN
ENDIF
IF ATC('.APP',SYS(16,0))>0
  DO README.SPR
  RETURN
ENDIF
IF ATC('GENSCRNX',_GENSCRN)=0
  WAIT "_GENSCRN='GENSCRNX.PRG' must be set in CONFIG.FP or from Command window";
       WINDOW NOWAIT
  RETURN
ENDIF
m.lastdefault=SYS(5)+CURDIR()
m.progpath=ALLTRIM(FULLPATH(' ',SYS(16)))
SET DEFAULT TO (m.progpath)
IF .NOT.FILE('LIBRARY.PJX')
  WAIT "File 'LIBRARY.PJX' does not exist" WINDOW NOWAIT
  SET DEFAULT TO (m.lastdefault)
  RETURN
ENDIF
IF .NOT.FILE('SAMPLE.PJX')
  WAIT "File 'SAMPLE.PJX' does not exist" WINDOW NOWAIT
  SET DEFAULT TO (m.lastdefault)
  RETURN
ENDIF
IF .NOT.FILE('README.SPR')
  m.build_all=.T.
ENDIF
IF m.build_all
  m.lastselect=SELECT()
  SELECT 0
  USE SAMPLE.PJX
  REPLACE ALL TIMESTAMP WITH 0 FOR UPPER(TYPE)=='S'
  USE
  SELECT (m.lastselect)
  WAIT 'Building project LIBRARY...' WINDOW NOWAIT
  BUILD PROJECT LIBRARY
ENDIF
WAIT 'Building project SAMPLE...' WINDOW NOWAIT
BUILD PROJECT SAMPLE
WAIT CLEAR
SET MESSAGE TO
ACTIVATE SCREEN
IF FILE('README.SPR')
  DO README.SPR
ELSE
  WAIT "File 'README.SPR' does not exist" WINDOW NOWAIT
ENDIF
ACTIVATE SCREEN
SET DEFAULT TO (m.lastdefault)
RETURN 

* END GSXDEMO
