***************************************************************************
*
* Procedure file: CONTROLS.PRG
*         System: GenScrnX
*        Version: 1.0
*         Author: Ken R. Levy
*        Company: Jet Propulsion Laboratory
*      Copyright: None (Public Domain)
*
***************************************************************************
*
* CONTROLS - Controls driver.
*
* Description:
* This program is used as an optional driver for use with GENSCRNX.PRG.
*
* Features:
* Insert spinner template.
* Fill box.
*
* Notes:
* In this program, for clarity/readability reasons, variable names
* are used that are longer than 10 characters.  Note, however, that only
* the first 10 characters are significant.
*
* Important:
* All function calls made from this program are contained in GENSCRNX.PRG.
* Variable names not declared PRIVATE in this program defined PRIVATE in
* GENSCRNX.PRG.
*
PRIVATE m.str_data,m.r,m.r2,m.str_data,m.str_len,m.at_pos
PRIVATE m.vpos2,m.hpos2,m.height2,m.width2,m.colorpair2
PRIVATE m.spnr_name,m.box_mode

IF .NOT.drvobj().OR.EMPTY(COMMENT)
  RETURN .F.
ENDIF
m.r=RECNO()
m.vpos2=VPOS
m.hpos2=HPOS
m.height2=HEIGHT
m.width2=WIDTH
DO CASE
  CASE OBJTYPE=15
    m.str_data=linesearch('*:SPINNER')
    IF m.str_data=m.null
      RETURN .F.
    ENDIF
    m.at_pos=ATC(' ',m.str_data)
    IF m.at_pos=0
      m.spnr_name=m.str_data
    ELSE
      m.spnr_name=LEFT(m.str_data,m.at_pos-1)
      m.str_data=ALLTRIM(SUBSTR(m.str_data,m.at_pos))
    ENDIF
    m.box_mode=.F.
    DO WHILE .NOT.EMPTY(m.str_data)
      IF UPPER(LEFT(m.str_data,3))=='BOX'
        m.box_mode=.T.
        m.str_data=ALLTRIM(SUBSTR(m.str_data,3))
        LOOP
      ENDIF
      EXIT
    ENDDO
    =basobj1('MAIN.SPINNER_')
    m.str_len=LEN(m.spnr_name)+1
    m.width2=MAX(WIDTH,5)
    REPLACE WIDTH WITH m.width2    
    IF .NOT.EMPTY(m.spnr_name)
      REPLACE HPOS WITH HPOS+m.str_len
    ENDIF
    IF m.str_len>1.AND.INSREC(-1)
      REPLACE OBJTYPE WITH 5, OBJCODE WITH 0,;
              EXPR WITH "'"+m.spnr_name+"'", VPOS WITH m.vpos2,;
              HPOS WITH m.hpos2, HEIGHT WITH 1, WIDTH WITH m.str_len-1
      SKIP
      IF TYPE('PLATFORM')=='C'.AND.ALLTRIM(PLATFORM)=='WINDOWS'
        REPLACE HPOS WITH HPOS+4
      ENDIF
      m.r=RECNO()
    ENDIF
    m.r=RECNO()
    IF m.box_mode.AND.m.vpos2>=1.AND.m.hpos2>=1.AND.;
       (m.vpos2+m.height2+2)<m.height.AND.;
       (m.hpos2+m.width2+m.str_len+2)<m.width.AND.INSREC()
      REPLACE OBJTYPE WITH 7, OBJCODE WITH 4, VPOS WITH m.vpos2-1,;
              HPOS WITH m.hpos2-1, HEIGHT WITH m.height2+2,;
              WIDTH WITH m.width2+m.str_len+2, FILLCHAR WITH m.null,;
              COLORPAIR WITH 'BG/B'
    ENDIF
    GOTO m.r
  CASE OBJTYPE=7
    m.str_data=linesearch('*:FILL')
    IF m.str_data=m.null
      RETURN .F.
    ENDIF
    m.colorpair2=IIF(EMPTY(COLORPAIR),'',' COLOR '+COLORPAIR)
    =INSTXT1("@ "+STR(VPOS,3)+","+;
             STR(HPOS,3)+" FILL TO "+STR(VPOS+HEIGHT-1,3)+","+;
             STR(HPOS+WIDTH-1,3)+m.colorpair2)
  OTHERWISE
    RETURN .F.
ENDCASE
RETURN .T.
