***************************************************************************
*
* Procedure file: OBJDATA.PRG
*         System: GenScrnX
*        Version: 1.0
*         Author: Ken R. Levy
*        Company: Jet Propulsion Laboratory
*      Copyright: None (Public Domain)
*
***************************************************************************
*
* OBJDATA - Object data search and evaluate driver.
*
* Description:
* This program is used as an optional driver for use with GENSCRNX.PRG.
*
* Features:
* Searches COMMENT memo field for string match and returns evaluation
* of parameter driven string.
*
* Notes:
* In this program, for clarity/readability reasons, variable names
* are used that are longer than 10 characters.  Note, however, that only
* the first 10 characters are significant.
*
* Important:
* All function calls made from this program are contained in GENSCRNX.PRG.
* Variable names not declared PRIVATE in this program defined PRIVATE in
* GENSCRNX.PRG.
*
PARAMETERS m.match_str,m.eval_str,m.lib_obj
PRIVATE m.match_str,m.eval_str,m.new_str,m.r,m.at_pos,m.i
PRIVATE m.obj_lib,m.obj_name,m.lstselect,m.lstorder,m.lstexac

m.new_str=''
IF .NOT.m.lib_obj
  m.r=RECNO()
  GOTO m.r_scxdata
  LOCATE REST FOR ATC(m.match_str,COMMENT)>0
  IF .NOT.EOF()
    m.new_str=EVALUATE(m.eval_str)
  ENDIF
  GOTO m.r
  RETURN m.new_str
ENDIF
m.lstselect=SELECT()
SELECT FOXSCX
IF EOF()
  LOCATE
ENDIF
m.r=RECNO()
m.lstorder=ORDER()
SET ORDER TO OBJNAME_
m.obj_lib=''
m.obj_name=PADR(ALLTRIM(UPPER(m.match_str)),LEN(FOXSCX.OBJNAME_))
m.at_pos=ATC('.',m.obj_name)
IF m.at_pos>0
  m.obj_lib=PADR(CHRTRAN(ALLTRIM(LEFT(m.obj_name,m.at_pos-1)),;
            m.badchars,m.stdascii),LEN(FOXSCX.OBJLIB_))
  m.obj_name=ALLTRIM(SUBSTR(m.obj_name,m.at_pos+1))
ENDIF
IF m.inclibs>0.OR..NOT.EMPTY(m.obj_lib)
  m.obj_name=PADR(CHRTRAN(m.obj_name,m.badchars,m.stdascii),;
             LEN(FOXSCX.OBJNAME_))
  IF EMPTY(m.obj_lib)
    m.lstexac=SET('EXACT')
    SET EXACT ON
    FOR m.i = 1 TO m.inclibs
      SEEK PADR(m.obj_name,LEN(OBJNAME_))+PADR(a_inclib(m.i),LEN(OBJLIB_))
      IF .NOT.EOF()
        m.obj_lib=OBJLIB_
        EXIT
      ENDIF
    ENDFOR
    IF m.lstexac=='ON'
      SET EXACT ON
    ELSE
      SET EXACT OFF
    ENDIF
  ENDIF
  SEEK m.obj_name+m.obj_lib
  IF .NOT.EOF()
    m.new_str=EVALUATE(m.eval_str)
  ENDIF
ENDIF
SET ORDER TO (m.lstorder)
GOTO m.r
SELECT (m.lstselect)
RETURN m.new_str
