@ECHO OFF
REM CHKCMOS.BAT -- ensures CMOS not damaged, repairs if it is.
REM insert in AUTOEXEC.BAT to check CMOS.
REM Must have done a CMOSSAVE C:\CMOS.SAV first

C:\SYS\CMOSChk.COM C:\CMOS.SAV
IF NOT Errorlevel 1 GOTO DONE

REM CMOS check failed:
REM could be 4 reasons:

REM 1. Never set up CMOS.SAV before

REM 2. CMOS.SAV has been deleted

REM 3. CMOS has been illegitimately tampered with

REM 4. CMOS has been deliberately changed, 
REM    Clever user will have to abort,
REM    then do a manual CMOSSAVE C:\CMOS.SAV
REM    Normally, he would just delete CMOS.SAV before changing,
REM    and this BAT file will recreate it.

IF NOT EXIST C:\CMOS.SAV GoTo MakeIt

Echo Abort now with Ctrl-Break if you do not wish to restore damaged CMOS
Pause

REM Presume reason 3, try restoring

C:\SYS\CMOSREST.COM C:\CMOS.SAV
IF NOT Errorlevel 1 GOTO DONE
Echo CMOS is still corrupted
Pause
GoTo Done

:MakeIt

REM Build a NEW CMOS.SAV file
Echo Missing CMOS.SAV file.  Recreating it.
Pause
C:\SYS\CMOSSAVE.COM C:\CMOS.SAV
Echo You might also want to create a new A: Rescue floppy boot disk soon
Echo Use CMOSSAVE A:\CMOS.SAV
Pause

:DONE
REM -30-
