PROGRAM DIRCTRY (INPUT,OUTPUT);

TYPE
  FILES_POINTER = ^NAME_DATA; {For the use of the dynamic array}
  NAME_DATA = RECORD
       NAME : STRING[13];
       SIZE : STRING[6];
       FTYPE : BYTE;
     END;
  FIND_FCB = RECORD           {Used to get directory data from DOS}
    OTHER : ARRAY[0..20] OF BYTE;
    ATTRIBUTE : BYTE;
    TIME : INTEGER;
    DATE : INTEGER;
    LO_SIZE : INTEGER;
    HI_SIZE : INTEGER;
    FILENAME : ARRAY[0..12] OF CHAR;
   END;
   REGISTERS = RECORD          {Used for DOS function calls}
     AX,BX,CX,DX,BP,SI,DI,DS,ES,FLAGS : INTEGER;
    END;

CONST
    ALL_FILES : STRING[3] =    {Constant to search for all files}
       '*.*';

VAR
  HEAPTOP : ^INTEGER;          {Marks the start of the dynamic table}
  POINTERS : ARRAY[1..256] OF FILES_POINTER;  {Static array for dynamic}
  NEXT_REC, THIS_REC : FILES_POINTER;         {pointers}
  MOD_FCB : FIND_FCB;          {Modified FCB used in DOS functions 4E, 4F}
  REGS : REGISTERS;
  DIRECTORIES : ARRAY[1..256] OF STRING[65]; {Array of directory paths}
  PATHNAME, SETUP_PATHNAME : STRING[65];  {Current pathname/original pathname}
  STATUS : BOOLEAN;            {Indicator of the success of getting file name}
  I, PNTR_ARRAY_PNTR, LAST_DIR_PNTR, LAST_FILE_PNTR, FILE_COUNT,
    DIR_ARRAY_PNTR, LINE_COUNT, PAGE : INTEGER;
  TEMP_SIZE, FREE : REAL;
  YEAR, MONTH, DAY : INTEGER;
  TYEAR, TMONTH, TDAY : STRING[4];
  TITLE : STRING[50];
  DRIVE : STRING[1];
  SECTORS_PER_CLUSTER, CLUSTERS_AVAIL, BYTES_PER_SECTOR : REAL;
  TOP_OF_FORM : BOOLEAN;

PROCEDURE GET_NEXT;

(* This procedure is used to get the next file from DOS using the modified *)
(* FCB created in function 4E in procedure FIND_FILES.  If a file is found *)
(* and it is not a directory pointer file (files named . and ..) then      *)
(* status is true.  If there are no more files to process then status is   *)
(* false.                                                                  *)

BEGIN
  MOD_FCB.FILENAME[0] := ' ';
  STATUS := FALSE;
  REGS.AX := $1A00;
  REGS.DS := SEG(MOD_FCB);
  REGS.DX := OFS(MOD_FCB);
  MSDOS(REGS);
  REGS.AX := $4F00;
  MSDOS(REGS);
  IF LO(REGS.AX) <> $12 THEN
   STATUS := TRUE;
  IF MOD_FCB.FILENAME[0] = '.' THEN
  GET_NEXT;
END;

PROCEDURE FIND_FILES;

(* This procedure is used to get the first file in a path and set up the   *)
(* modified FCB that is used to get the rest of the files and is used by   *)
(* procedure GET_NEXT.                                                     *)

BEGIN
  STATUS := FALSE;
  CHDIR(PATHNAME);
  REGS.AX := $1A00;
  REGS.DS := SEG(MOD_FCB);
  REGS.DX := OFS(MOD_FCB);
  MSDOS(REGS);{SET UP DTA}
  REGS.AX := $4E00;
  REGS.CX := $003F;
  REGS.DS := SEG(ALL_FILES);
  REGS.DX := OFS(ALL_FILES) + 1;
  MSDOS(REGS);
  IF LO(REGS.AX) <> $12 THEN
    STATUS := TRUE;
  IF MOD_FCB.FILENAME[0] = '.' THEN
  GET_NEXT;
END;


PROCEDURE SORT;

(* This procedure sorts the pointers in the pointer array that point to    *)
(* the entries in the dynamic table.  The first sort puts all of the       *)
(* items in alphabetical order.  The second sort puts the directory        *)
(* entries at the front of the array.                                      *)

BEGIN
  I := FILE_COUNT;
  WHILE I > 1 DO
  BEGIN;
    PNTR_ARRAY_PNTR := FILE_COUNT;
    WHILE PNTR_ARRAY_PNTR > 1 DO
    BEGIN
      THIS_REC := POINTERS[PNTR_ARRAY_PNTR];
      NEXT_REC := POINTERS[PNTR_ARRAY_PNTR -1];
      IF THIS_REC^.NAME < NEXT_REC^.NAME THEN
      BEGIN
        POINTERS[PNTR_ARRAY_PNTR] := NEXT_REC;
        POINTERS[PNTR_ARRAY_PNTR - 1] := THIS_REC;
      END;
      PNTR_ARRAY_PNTR := PNTR_ARRAY_PNTR - 1;
    END;
    I := I - 1;
  END;
  I := FILE_COUNT;
  WHILE I > 1 DO
  BEGIN;
    PNTR_ARRAY_PNTR := FILE_COUNT;
    WHILE PNTR_ARRAY_PNTR > 1 DO
    BEGIN
      THIS_REC := POINTERS[PNTR_ARRAY_PNTR];
      NEXT_REC := POINTERS[PNTR_ARRAY_PNTR -1];
      IF (THIS_REC^.FTYPE AND $10) > (NEXT_REC^.FTYPE AND $10) THEN
      BEGIN
        POINTERS[PNTR_ARRAY_PNTR] := NEXT_REC;
        POINTERS[PNTR_ARRAY_PNTR - 1] := THIS_REC;
      END;
      PNTR_ARRAY_PNTR := PNTR_ARRAY_PNTR - 1;
    END;
    I := I - 1;
  END;
END;

PROCEDURE GET_FILES;

(* This routine is used to get the files in the current path.  It calls    *)
(* the procedures FIND_FILES and GET_NEXT.  It uses a dynamic table to hold*)
(* the directory information.  After all of the information is processed   *)
(* the dynamic array is release and consequently destroyed.                *)

BEGIN
  PNTR_ARRAY_PNTR := 1;
  POINTERS[PNTR_ARRAY_PNTR] := NIL;
  STATUS := TRUE;
  WHILE STATUS DO
  BEGIN
    I := 0;
    WHILE I < 13 DO
    BEGIN
      MOD_FCB.FILENAME[I] := CHR(32);
      I := I + 1;
    END;
    IF POINTERS[1] = NIL THEN
      FIND_FILES
    ELSE
      GET_NEXT;
    IF STATUS THEN
    BEGIN
      NEW(THIS_REC);
      POINTERS[PNTR_ARRAY_PNTR] := THIS_REC;
      PNTR_ARRAY_PNTR := PNTR_ARRAY_PNTR + 1;
      POINTERS[PNTR_ARRAY_PNTR] := NIL;
      THIS_REC^.NAME := MOD_FCB.FILENAME;
      TEMP_SIZE := 0;
      TEMP_SIZE := MOD_FCB.HI_SIZE * 6.5536E04;
      IF MOD_FCB.LO_SIZE < 0 THEN
        TEMP_SIZE := TEMP_SIZE + 6.5536E04 + MOD_FCB.LO_SIZE
      ELSE
        TEMP_SIZE := TEMP_SIZE + MOD_FCB.LO_SIZE;
      STR(TEMP_SIZE:6:0,THIS_REC^.SIZE);
      IF (MOD_FCB.ATTRIBUTE AND $10) <> 0 THEN
        THIS_REC^.SIZE := '  DIR ';
      THIS_REC^.FTYPE := MOD_FCB.ATTRIBUTE;
    END {IF};
  END {WHILE STATUS};
  FILE_COUNT := PNTR_ARRAY_PNTR - 1;
END{PROCEDURE};

PROCEDURE HEADER;

(* Procedure HEADER outputs a cover header to the printer.  Initially the  *)
(* routine sets up the printer.  HEADER assumes an Epson printer.  HEADER  *)
(* also keeps track if the entry being printed is at the top or bottom of  *)
(* the page so form feeds can be used to advance the page.                 *)

VAR
  TFREE, TPAGE : STRING[7];

BEGIN;
  STR(FREE:7:0,TFREE);
  STR(PAGE:2,TPAGE);
  WRITE(LST,CHR(27),'0',CHR(15),CHR(27),'D',CHR(60),CHR(0));
  WRITELN(LST,'Ŀ');
  WRITE(LST,'|   ',TITLE,CHR(13),CHR(9),'FREE: ',TFREE,'          |',CHR(13),CHR(10));
  WRITE(LST,'|   PAGE - ',TPAGE,CHR(9),TMONTH,'/',TDAY,'/',TYEAR,'               |',CHR(13),CHR(10));
  LINE_COUNT := 3;
  IF TOP_OF_FORM = TRUE THEN
    TOP_OF_FORM := FALSE
  ELSE
    TOP_OF_FORM := TRUE;
END;

PROCEDURE REST_OF_FORM;

(* This procedure is used to output the rest of the form that is not       *)
(* printed by the output columns routine.  Each form has 38 lines.         *)
(* REST_OF_FORM checks to see if the last output was to the bottom of the  *)
(* the page and if it is uses a form feed to advance the page.             *)

BEGIN
  WHILE LINE_COUNT < 37 DO
  BEGIN
    WRITELN(LST,'|',CHR(9),'                       |');
    LINE_COUNT := LINE_COUNT + 1;
  END;
  WRITELN(LST,'');
  IF NOT TOP_OF_FORM THEN
    WRITE(LST,CHR(13),CHR(10),CHR(10),CHR(10),CHR(10))
  ELSE
    WRITE(LST,CHR(12),CHR(13));
  PAGE := PAGE + 1;
END;

PROCEDURE OUTPUT_COLUMNS;

(* This routine outputs the path name, the number of entries, and the      *)
(* directory entry names in alphabetical order in four columns.            *)

VAR
  ROW_INDEX, BASE_INDEX, EXTRA_INDEX, X : INTEGER;
  TPATH : STRING[65];

BEGIN
  ROW_INDEX := FILE_COUNT SHR 2;
  BASE_INDEX := 1;
  TPATH := COPY(PATHNAME,3,LENGTH(PATHNAME));
  IF LINE_COUNT > 31 THEN
  BEGIN
    REST_OF_FORM;
    HEADER;
  END;
  WRITELN(LST,'|',CHR(9),'                       |');
  WRITE(LST,'|');
  WRITE(LST,CHR(27),'E',TPATH,CHR(27),'F',CHR(9),'NO. OF ENTRIES : ',FILE_COUNT);
  WRITELN(LST,CHR(13),CHR(9),'                       |');
  WRITELN(LST,'|',CHR(9),'                       |');
  LINE_COUNT := LINE_COUNT + 3;
  WHILE BASE_INDEX <= ROW_INDEX DO
  BEGIN
    X := 0;
    WRITE(LST,'|  ');
    WHILE X < 4 DO
    BEGIN
      THIS_REC := POINTERS[BASE_INDEX + X * ROW_INDEX];
      WRITE(LST,THIS_REC^.NAME,THIS_REC^.SIZE,'  ');
      X := X + 1;
    END;
    BASE_INDEX := BASE_INDEX + 1;
    WRITELN(LST,'|');
    LINE_COUNT := LINE_COUNT + 1;
    IF LINE_COUNT = 37 THEN
    BEGIN
      REST_OF_FORM;
      HEADER;
      WRITELN(LST,CHR(13),CHR(9),'                       |');
      LINE_COUNT := LINE_COUNT + 1;
    END;
  END;
  EXTRA_INDEX := FILE_COUNT - 4 * ROW_INDEX;
  IF EXTRA_INDEX <> 0 THEN
  BEGIN
    X := 0;
    WRITE(LST,'|  ');
    WHILE X < EXTRA_INDEX DO
    BEGIN
      THIS_REC := POINTERS[ROW_INDEX + 1 + X * ROW_INDEX];
      WRITE(LST,THIS_REC^.NAME,THIS_REC^.SIZE,'  ');
      X := X+1;
    END;
    WRITELN(LST,CHR(13),CHR(9),'                       |');
    LINE_COUNT := LINE_COUNT + 1;
  END;
END;

PROCEDURE MOVE_DIRECTORIES;

(* This procedure moves the directory entries from the dynamic array into  *)
(* a static array that contains the pathnames of all directory entries.    *)

BEGIN
  PNTR_ARRAY_PNTR := 1;
  IF POINTERS[PNTR_ARRAY_PNTR] <> NIL THEN
  BEGIN
    THIS_REC := POINTERS[PNTR_ARRAY_PNTR];
    WHILE THIS_REC^.FTYPE AND $10 <> 0 DO
    BEGIN
      LAST_DIR_PNTR := LAST_DIR_PNTR + 1;
      IF POS(' ',PATHNAME) <> 0 THEN
        DELETE(PATHNAME,POS(' ',PATHNAME) - 1,65);
      IF PATHNAME[LENGTH(PATHNAME)] <> '\' THEN
        PATHNAME := PATHNAME + '\';
      DIRECTORIES[LAST_DIR_PNTR] := PATHNAME + THIS_REC^.NAME;
      PNTR_ARRAY_PNTR := PNTR_ARRAY_PNTR + 1;
      THIS_REC := POINTERS[PNTR_ARRAY_PNTR];
   END;
 END;
END;





{*****************************************************************************}
{*                                                                           *}
{*                                CONTROL LOOP                               *}
{*                                                                           *}
{*****************************************************************************}

BEGIN
  CLRSCR;
  WRITE(LST,CHR(27),'@');      {Reset printer}
  TOP_OF_FORM := TRUE;
  REGS.AX := $2A00;            {Get date}
  MSDOS(REGS);
  YEAR := REGS.CX;
  MONTH := HI(REGS.DX);
  DAY := LO(REGS.DX);
  STR(YEAR:4,TYEAR);           {Convert date}
  STR(MONTH:2,TMONTH);
  STR(DAY:2,TDAY);
  DELETE(TYEAR,1,2);
  SETUP_PATHNAME := '                                                                ';
    {needed to set up string size for Pascal}
  REGS.AX := $1900;            {Get default disk drive}
  MSDOS(REGS);
  SETUP_PATHNAME := CHR(LO(REGS.AX)+65) + ':\' + SETUP_PATHNAME;
  REGS.DX := $0000;            {Get the current path}
  REGS.DS := SEG(SETUP_PATHNAME);
  REGS.SI := OFS(SETUP_PATHNAME) + 4;
  REGS.AX := $4700;
  MSDOS(REGS);
  DELETE(SETUP_PATHNAME,POS(' ',SETUP_PATHNAME),65);
  DRIVE := ' ';
  WHILE LENGTH(DRIVE) <> 0 DO
  BEGIN
    PAGE := 1;
    WRITELN;
    WRITE('ENTER DISK DRIVE - ');     {Get drive to print cover for}
    READLN(DRIVE);
    IF DRIVE <> '' THEN
    BEGIN;
      PATHNAME := DRIVE + ':\';
      WRITE('ENTER TITLE - ');
      READLN(TITLE);
      DRIVE := UPCASE(DRIVE[1]);        {Get disk free space}
      REGS.DX := ORD(DRIVE) - 64;
      REGS.AX := $3600;
      MSDOS(REGS);
      SECTORS_PER_CLUSTER := REGS.AX;
      CLUSTERS_AVAIL := REGS.BX;
      BYTES_PER_SECTOR := REGS.CX;
      FREE := SECTORS_PER_CLUSTER * CLUSTERS_AVAIL * BYTES_PER_SECTOR;
      HEADER;
      MARK(HEAPTOP);                    {Mark dynamic array}
      GET_FILES;                        {Get data and make output for root}
      SORT;
      OUTPUT_COLUMNS;
      LAST_DIR_PNTR := 0;
      MOVE_DIRECTORIES;
      RELEASE(HEAPTOP);
      IF LAST_DIR_PNTR <> 0 THEN        {See if there are any more directories}
      BEGIN
        DIR_ARRAY_PNTR := 1;
        WHILE DIR_ARRAY_PNTR <= LAST_DIR_PNTR DO
        BEGIN
          PATHNAME := DIRECTORIES[DIR_ARRAY_PNTR]; {Get data for new directories}
          MARK(HEAPTOP);
          GET_FILES;
          SORT;
          OUTPUT_COLUMNS;
          MOVE_DIRECTORIES;
          RELEASE(HEAPTOP);
          DIR_ARRAY_PNTR := DIR_ARRAY_PNTR + 1;
        END;
      END;
    REST_OF_FORM;
    END;
  END;
  IF NOT TOP_OF_FORM THEN             {Do form feed if not at top-of-form}
    WRITE(LST,CHR(12),CHR(13));
  WRITE(LST,CHR(27),'@');             {Reset printer}
  CHDIR(SETUP_PATHNAME)               {Return to original directory}
END.

