* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
* DB-LOG V1.02 Copyright (c) 1992-1993 DL Systems, Inc. All rights reserved.
*
* This program demonstrates the use of the DBLOGCLP.OBJ procedures included
* with with the DB-LOG package.
*
* These functions are design for use with Clipper(tm).
*
* NOTE: The transaction system procedures are not demonstrated in this program.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
*	 Name: DBLOGINST()
*
*     Purpose: To determine if the DB-LOG TSR is initialized.
*
*	Usage: DBLOGINST()
*
*	       Returns logical variable:
*
*	       .T. if DB-LOG is initialized.
*
*	       .F. if DB-LOG is not initialized.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
*	 Name: DBLOGSUSP()
*
*     Purpose: To determine if the DB-LOG TSR has been suspended.
*
*	Usage: DBLOGSUSP()
*
*	       Returns logical variable:
*
*	       .T. if DB-LOG is suspended.
*
*	       .F. if DB-LOG is not suspended.
*
*
*	 NOTE: If this procedure is called when DB-LOG is not initialized,
*	       unpredictible results will occur.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
*	 Name: DBLOGERROR()
*
*     Purpose: To determine if the DB-LOG TSR has encountered any errors.
*
*	Usage: DBLOGERROR()
*
*	       Returns 4 byte character string with error information.
*
*		    Byte 1 = 'F' if file/path not found errors have occurred.
*
*		    Byte 1 = ' ' (space decimal 32) if file/path not found have
*				 not occurred.
*
*		    Byte 2 = 'M' if miscellaneous open file errors have
*				 occurred.
*
*		    Byte 2 = ' ' (space decimal 32) if miscellaneous open file
*				 errors have not occurred.
*
*		    Byte 3 = 'H' if no file handles left errors have occurred.
*
*		    Byte 3 = ' ' (space decimal 32) if no file handles left
*				 errors have not occured.
*
*		    Byte 4 = 'D' if miscellaneous DOS errors have occurred.
*
*		    Byte 4 = ' ' (space decimal 32) if miscellaneous DOS errors
*				 have not occured.
*
*
*	 NOTE: If this procedure is called when DB-LOG is not initialized,
*	       unpredictible results will occur.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
*	 Name: DBLOGPATH()
*
*     Purpose: To return the path that DB-LOG uses for log files.
*
*	Usage: DBLOGPATH()
*
*	       Returns character string with complete drive and path starting
*	       at the root for log files.
*
*
*	 NOTE: If this procedure is called when DB-LOG is not initialized,
*	       unpredictible results will occur.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
*	 Name: DBLOGTBSRC()
*
*     Purpose: To return the source file for one of the 2 file table entries.
*
*	Usage: DBLOGTBSRC(Entry_num)
*
*	       Entry_num >	Entry number (1 - 2) of the file table to
*				return.
*
*	       Returns filename and extension of the file being logged.
*
*
*	 NOTE: If this procedure is called when DB-LOG is not initialized,
*	       unpredictible results will occur.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*
*	 Name: DBLOGTBLOG()
*
*     Purpose: To return the log file for one of the 2 file table entries.
*
*	Usage: DBLOGTBLOG(Entry_num)
*
*	       Entry_num >	Entry number (1 - 2) of the file table to
*				return.
*
*	       Returns filename and extension of the log file.
*
*
*	 NOTE: If this procedure is called when DB-LOG is not initialized,
*	       unpredictible results will occur.
*
* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *



* DBLOGINST DEMO ===============================================================
If .NOT. DBLOGINST()
   ? 'DB-LOG not initialzed'            && DB-LOG is not initialized.
   ?
   Quit
Else					&& If version is not space(4) then
   ? 'DB-LOG installed'
Endif



* DBLOGSUSP DEMO ===============================================================
If DBLOGSUSP()
   ? 'DB-LOG suspended'
Endif



* DBLOGERROR DEMO ==============================================================
If Substr(DBLOGERROR(), 1, 1) = 'F'     && If first byte is 'F' then
   ? 'File/path not found errors'       && file/path not found errors have
Endif					&& occurred.
If Substr(DBLOGERROR(), 2, 1) = 'M'     && If second byte is 'M' then
   ? 'Misc open file errors'            && misc open file errors have occurred.
Endif
If Substr(DBLOGERROR(), 3, 1) = 'H'     && If third byte is 'H' then
   ? 'No file handles left errors'      && no file handles left errors have
Endif					&& occurred.
If Substr(DBLOGERROR(), 4, 1) = 'D'     && If fourth byte is 'D' then
   ? 'Misc DOS errors'                  && misc DOS errors have occurred.
Endif



* DBLOGPATH DEMO ===============================================================
? 'LOGPATH = ' + DBLOGPATH()



* DBLOGTABLE DEMO ==============================================================
?
? 'LIST OF LOGGED FILES'

Entry_num = 0

DO WHILE Entry_num < 2			&& Loop to get all 2 file table
					&& entries.
   Entry_num = Entry_num + 1

   If LEN(DBLOGTBSRC(Entry_num)) <> 0	&& Call DB-LOG to get file table entry.
      ? DBLOGTBSRC(Entry_num) + ' ' ;   && entry, then this entry of the 2
	+ DBLOGTBLOG(Entry_num) 	&& is being used
   Endif

Enddo

?
