/* intui.c:
 *
 * System requester stuff.
 *
 * ----------------------------------------------------------------------
 * This code is (C) Copyright 1993 by Frank Munkert.
 * All rights reserved.
 * This software may be freely distributed and redistributed for
 * non-commercial purposes, provided this notice is included.
 */

#include <stdarg.h>
#include <stdio.h>

#include <exec/types.h>
#include <intuition/intuition.h>

#include <clib/exec_protos.h>
#include <clib/intuition_protos.h>

#include "intui.h"

struct Library *IntuitionBase;

void Init_Intui (void)
{
  IntuitionBase = OpenLibrary ((UBYTE *) "intuition.library", 36);
}

void Close_Intui (void)
{
  if (IntuitionBase)
    CloseLibrary (IntuitionBase);
}

void Display_Error (char *p_message, ...)
{
  va_list arg;
  char buf[1000];

  static struct EasyStruct req = {
    sizeof (struct EasyStruct),
    0,
    (UBYTE *) "CDROM Handler Error",
    NULL,
    (UBYTE *) "Abort"
  };
  
  va_start (arg, p_message);
  vsprintf (buf, p_message, arg);
  if (IntuitionBase) {
    req.es_TextFormat = (UBYTE *) buf;
    EasyRequest (NULL, &req, NULL, NULL);
  }
  va_end (p_message);
}
