/*
 *      **************************************************************
 *       JdeBP C++ Library Routines      General Public Licence v1.00
 *          Copyright (c) 1991,1992  Jonathan de Boyne Pollard
 *      **************************************************************
 *
 * MATHEMATICAL FUNCTIONS (ANSI)
 *
 */

#if !defined(___STDDEF_H_INCLUDED)
#include <_stddef.h>
#endif

typedef const union {
    unsigned short W[4];        // For accessing as an array of short
    double D;                   // For accessing as a double
} _DoubleConst;

extern "C" {

double  _CDECL acos     (double);
double  _CDECL asin     (double);
double  _CDECL atan     (double);
double  _CDECL atan2    (double, double);
double  _CDECL atof     (const char  *);
double  _CDECL ceil     (double);
double  _CDECL cos      (double);
double  _CDECL cosh     (double);
double  _CDECL exp      (double);
double  _CDECL fabs     (double);
double  _CDECL floor    (double);
double  _CDECL fmod     (double, double);
double  _CDECL frexp    (double, int  *);
double  _CDECL ldexp    (double, int);
double  _CDECL log      (double);
double  _CDECL log10    (double);
double  _CDECL modf     (double, double  *);
double  _CDECL pow      (double, double);
double  _CDECL sin      (double);
double  _CDECL sinh     (double);
double  _CDECL sqrt     (double);
double  _CDECL tan      (double);
double  _CDECL tanh     (double);

extern _DoubleConst _CDECL  _HugeVal;

}

#define HUGE_VAL _HugeVal.D
