/*
 * File......: LOCKMODE.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "netto.ch"
#include "ftint86.ch"

#define GET_LOCKMODE         2

/*  $DOC$
 *  $FUNCNAME$
 *     fn_getLMod()
 *  $CATEGORY$
 *     Synchronization
 *  $ONELINER$
 *     Get lock mode
 *  $SYNTAX$
 *     
 *     fn_getLMod() -> nLockMode
 *
 *  $ARGUMENTS$
 *
 *     None
 *
 *  $RETURNS$
 *
 *     <nLockMode>, a numeric, as follows:
 *
 *         0  =  NetWare 4.0-style "compatibility mode"
 *         1  =  NetWare 4.6 and later "extended lock mode"
 *
 *  $DESCRIPTION$
 *
 *     Lock modes in NetWare are an outgrowth of some changes in 
 *     NetWare locking behavior which happened in an early revision
 *     of NetWare.  At the time, lock mode 0 was provided for 
 *     compatibility.
 *
 *     Lock modes affect the behavior of the "log physical" and 
 *     "lock physical" calls, as well as the logical file locking
 *     calls. 
 *
 *     All programs today should be written to the extended lock
 *     mode (mode 1), which is _not_ the default. Therefore, you
 *     should consider setting lock mode to 1 before using the 
 *     physical log and lock calls.
 *
 *     (Note: it is possible the physical log and lock calls are
 *     not available in this release.  If so, never mind)
 *     
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *     FN_SETLMOD()
 *  $INCLUDE$
 *
 *  $END$
 */



function fn_getLMod()
  return  _fnLockMod( GET_LOCKMODE )



/*  $DOC$
 *  $FUNCNAME$
 *     fn_setLMod()
 *  $CATEGORY$
 *     Synchronization
 *  $ONELINER$
 *     Set lock mode
 *  $SYNTAX$
 *
 *      fn_setLMod( <nLockMode> ) -> nCurMode
 *
 *  $ARGUMENTS$
 *
 *     <nLockMode>, a numeric, as follows:
 *
 *         0  =  NetWare 4.0-style "compatibility mode"
 *         1  =  NetWare 4.6 and later "extended lock mode"
 *         2  =  Just return the current lock mode
 *               ( you can use fn_getLMod() instead )
 *
 *  $RETURNS$
 *
 *     <nCurMode>, a numeric, indicating the current lock mode.
 *
 *  $DESCRIPTION$
 *
 *     Lock modes in NetWare are an outgrowth of some changes in 
 *     NetWare locking behavior which happened in an early revision
 *     of NetWare.  At the time, lock mode 0 was provided for 
 *     compatibility.
 *
 *     Lock modes affect the behavior of the "log physical" and 
 *     "lock physical" calls, as well as the logical file locking
 *     calls. 
 *
 *     All programs today should be written to the extended lock
 *     mode (mode 1), which is _not_ the default. Therefore, you
 *     should consider setting lock mode to 1 before using the 
 *     physical log and lock calls.
 *
 *     (Note: it is possible the physical log and lock calls are
 *     not available in this release.  If so, never mind)
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *     FN_GETLMOD()
 *  $INCLUDE$
 *
 *  $END$
 */


function fn_setLMod( nMode )
  return  _fnLockMod( nMode )


static function _fnLockMod( nMode )
  local aRegs[ INT86_MAX_REGS ]

  default nMode to GET_LOCKMODE

  aRegs[AX] := makehi( 198 )             // C6h
  aRegs[AX] += nMode

  _fnSetErr( iif( ft_int86( INT21, aRegs ), ESUCCESS, EINT86 ) )

  return  UNSIGNED( lowbyte( aRegs[AX] ) )

