/*
 * File......: RENDIR.PRG
 * Author....: Ted Means
 * CIS ID....: 73067,3332
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Ted Means and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "netto.CH"

/*  $DOC$
 *  $FUNCNAME$
 *     FN_RENDIR()
 *  $CATEGORY$
 *     File System
 *  $ONELINER$
 *     Rename directory
 *  $SYNTAX$
 *
 *     fn_RenDir( <nHandle>, <cPath>, <cNewName>  ) --> <nStatus>
 *
 *  $ARGUMENTS$
 *
 *    <nHandle> is a handle to a directory path, usually obtained with
 *              fn_alTemDH().
 *
 *    <cPath> is the desired pathspec.  If the pathspec is fully defined
 *            by the handle, then pass an empty string or NIL.
 *
 *    <cNewName> is the new directory name.  Note that it is the name only,
 *               not the entire pathspec.
 *  $RETURNS$
 *
 *    <nStatus> will be zero if the directory was deleted.  If an error
 *              occurred then <nStatus> will contain a NetWare error code;
 *              likely possibilities are NO_RENAME_PRIVILEGES,
 *              BAD_DIRECTORY_HANDLE, or INVALID_PATH.
 *
 *  $DESCRIPTION$
 *
 *    This call allows the developer to change the name of a directory, given
 *    the directory handle/path specification and the new name of the
 *    directory.  Rename privileges must be in effect and the new directory
 *    name cannot already exist.
 *
 *  $EXAMPLES$
 *    // Rename a directory on the SYS volume
 *
 *    fn_RenDir(  0, "SYS:\THISDIR\THATDIR", "YOURDIR" )
 *
 *    // Rename a directory on the VOL1 volume using a handle
 * 
 *    aDHInfo := fn_alTemDH( 0, "Z", "VOL1:\THISDIR" )
 *
 *    fn_RenDir( aDHInfo[ 1 ], "THATDIR", "YOURDIR" )
 *
 *  $SEEALSO$
 *    fn_MkDir() fn_GetCD() fn_RmDir()
 *  $INCLUDE$
 *    netto.CH (only needed if you want to make use of the #defines for
 *              the error codes).
 *  $END$
 */

function fn_RenDir( nHandle, cPath, cNew )
  local cReply

  default cPath to ""

  cReply := i2bin( 0 )
  return _fnReq( 226, chr( 15 )           + ;   // Subservice 0Fh
                       chr( nHandle )      + ;   // Convert handle to char
                       chr( len( cPath ) ) + ;   // Length of pathspec
                       cPath               + ;   // Pathspec
                       chr( len( cNew ) )  + ;   // Length of new name
                       cNew,                 ;   // New name
                       @cReply )



