/*
 * File......: SHVER.PRG
 * Author....: Steve Larsen
 * CIS ID....: 76370,1532
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Steve Larsen and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "ftint86.ch"
#include "netto.ch"

#define E3h	227


/*  $DOC$
 *  $FUNCNAME$
 *      fn_shVer()
 *  $CATEGORY$
 *      Connection/Workstation
 *  $ONELINER$
 *      GetNetwareShellVersion
 *  $SYNTAX$
 *
 *      fn_shVer() -> cShellVersion
 *
 *  $ARGUMENTS$
 *
 *      None
 *
 *  $RETURNS$
 *
 *      A string containing the current shell's version info.  If the
 *      shell is not loaded, "" is returned.
 *
 *  $DESCRIPTION$
 *
 *      The Shell version returned is a string consisting of four parts:
 *      the Major version, the Minor version, any Revision Letter and
 *      a notation if the Shell Type is for conventional, Expanded or
 *      Extended memory.
 *
 *      The construct of the returned string is as follows:
 *
 *      cShellVersion := <MajorVersion>.<MinorVersion><Revision><Type>
 *
 *      To distinquish between Revision and Shell Type designators (both
 *      are alphanumeric), the Revision is always returned in uppercase,
 *      whereas the Type is returned in lowercase if Expanded (e) or
 *      Extended (x).  No Shell Type is returned for conventional memory.
 *
 *  $EXAMPLES$
 *
 *      /* Shell is version 3.01, rev. A and loaded in conventional memory
 *
 *      ? fn_shVer()                   // 3.01A
 *
 *      /* Shell is version 3.02, rev. B and loaded in expanded memory
 *
 *      ? fn_shVer()                   // 3.02Be
 *
 *      /* Shell is version 3.22, and loaded in extended memory
 *
 *      ? fn_shVer()                   // 3.22x
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

FUNCTION fn_shVer()
	LOCAL cRepBuffer := REPLICATE( I2BYTE( 0 ) , 40 )
	LOCAL aRegs[ INT86_MAX_REGS ], cRetVal := ""

	aRegs[ AX ] := ft_HEX2DEC( "EA00" )   // Netware Service EAh, Function 01

	IF !ft_int86( INT21, aRegs )          // call Netware
		_fnSetErr( EINT86 )
	ENDIF

	IF aRegs[ AX ] >= 0
	/* construct shell version */
		cRetVal :=                                                            ;
		( ALLTRIM( STR( HighByte( aRegs[ BX ] ) ) ) + '.'                    +;
		  ALLTRIM( STR( LowByte(  aRegs[ BX ] ) ) )                          +;
		  I2BYTE(  65 + LowByte(  aRegs[ CX ] ) )               	 				+;
		  IF( HighByte( aRegs[ BX ] ) >= 3, 											 ;
		     IF( HighByte( aRegs[ CX ] ) > 0, 					      			 	 ;
				  IF( HighByte( aRegs[ CX ] ) = 1, "e", "x" ), '' ), ) )
	ENDIF
RETURN cRetVal
