/*
 * File......: CHGOSEC.PRG
 * Author....: Kevin Maher/Steve Tyrakowski
 * CIS ID....: 73766,1224
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Kevin Maher and Steve Tyrakowski
 * and is placed in the public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FN_cBndOse()
 *  $CATEGORY$
 *     Bindery
 *  $ONELINER$
 *     Change Bindery Object Security
 *  $SYNTAX$
 *
 *     FN_cBndOse(nWrite, nRead, cObject, nType) => lChanged
 *
 *  $ARGUMENTS$
 *
 *     <nWrite> is the Property write security as an integer.
 *      The integer indicates who can add properties
 *      to the bindery object.
 *
 *     <nRead> is the Property read security as an integer.
 *          The integer indicates who can read and scan
 *          properties for a bindery object.
 *
 *         Ŀ
 *          Read and Write Security Levels  
 *         Ĵ
 *          0 Anyone                       
 *         Ĵ
 *          1 Logged                       
 *         Ĵ
 *          2 Object                       
 *         Ĵ
 *          3 Supervisor                   
 *         Ĵ
 *          4 Netware Operating System     
 *         
 *
 *     <cObjectName> is the name of the Bindery Object that you are
 *           trying to change the security for.  Max Length = 47
 *
 *     <nObjectType> is the Bindery Object Type.  Manifest constants
 *           describing the defined types are included in the
 *           NETTO.CH header file.  Wildcard characters are
 *           not allowed.
 *
 *  $RETURNS$
 *
 *     <lChanged> logical if security was changed or not.
 *      If an error occurs, .F. will be the return value.
 *
 *  $DESCRIPTION$
 *
 *     This function changes the security of a bindery object.
 *     It requires SUPERVISOR rights.
 *
 *  $SEEALSO$
 *     fn_cProSec()
 *  $EXAMPLES$
 *
 *     // this will make KEVIN's security to SUPERVISOR
 *     lChanged := FN_cBndOse(3,3, "KEVIN", OT_USER)
 *
 *  $END$
 */

#include "ftint86.ch"
#include "netto.ch"

#define NW_LOG 227

#ifdef FT_TEST
  FUNCTION MAIN(nWrite, nRead, cObject, nType)
    IF FN_cBndOse(Val(nWrite), Val(nRead), cObject, Val(nType))
      Qout("Object security was successfully changed.")
    ELSE
      Qout("Object security was not changed.")
    ENDIF
  RETURN ( nil )

#endif

FUNCTION FN_cBndOse(nWrite, nRead, cObject, nType)

  LOCAL cSend := I2BYTE(56);                // 38h API request Code
          + I2BYTE((nWrite * 16) + nRead);  // Security Levels
          + W2HILO(nType);                  // nw_int Object type
          + FN_NameL(cObject,48)            // Object Name

RETURN _fnReq(NW_LOG,cSend,"") == ESUCCESS

