/*
 * File......: LOGFILE.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "netto.ch"
#include "ftint86.ch"

#define LOG_FILE             0
#define LOG_AND_LOCK_FILE    1
#define NO_WAIT              0

/*  $DOC$
 *  $FUNCNAME$
 *     FN_LOGFILE()
 *  $CATEGORY$
 *     Synchronization
 *  $ONELINER$
 *     Log file (ASCIIZ)
 *  $SYNTAX$
 *
 *     fn_logFile( cFn, nLockDir, nTimeout ) -> nRes
 *
 *  $ARGUMENTS$
 *
 *     <cFn>        - File path (full path and name of file)
 *                    Maximum length is 254 characters
 *
 *     <nLockDir>   - Locking directive:
 *                     
 *                        0 = Log File.  This only logs the record
 *                            in the table; it does not lock the file.
 *                        1 = Log and Lock File
 *
 *                    The default is 0.
 *
 *     <nTimeout>   - Amount of time to wait for a file to 
 *                    become available, in ticks (1 tick = 
 *                    1/18th of a second).  0 (the default) =
 *                    no wait.
 *
 *     The <nLockDir> and <nTimeOut> parameters are only supported
 *     in "extended lock mode" (see FN_GETLMOD()) and will be 
 *     ignored if you are currently in "compatibility mode."
 *
 *  $RETURNS$
 *
 *     <nRes>, a numeric, as follows:
 *
 *         If you're in extended lock mode:
 *
 *                 0   =  Success
 *               150   =  Server out of memory
 *               254   =  Timeout failure
 *               255   =  Hardware failure
 *
 *         If you're in compatibility mode:
 *
 *                 0   =  No error
 *               255   =  Failure
 *
 *  $DESCRIPTION$
 *
 *      This is the first call you use to do file locks.  You use this
 *      call to place the name of the file in a log table the server
 *      maintains for each workstation, and optionally lock the file.
 *
 *      You can log more files if you need to and lock them later with
 *      fn_lkFiSet().
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *     FN_GETLMOD() FN_SETLMOD()
 *  $INCLUDE$
 *
 *  $END$
 */

function fn_logFile( cFn, nLockDir, nTimeout )          // Log file (ASCIIZ)
  local aRegs[ INT86_MAX_REGS ], nCurMode

  default cFn      to "",       ;
          nLockDir to LOG_FILE, ;
          nTimeOut to NO_WAIT

  cFn := iif( len( cFn ) > 254, substr( cFn, 1, 254 ), cFn )
  cFn += chr( 0 )

  nCurMode := fn_getLMod()

  aRegs[ AX ]          := makehi( 235 )     // EBh
  aRegs[ DS ]          := cFn
  aRegs[ DX ]          := REG_DS

  if nCurMode == 1                          // Extended lock mode?
    aRegs[ AX ]          += nLockDir
    aRegs[ BP ]          := nTimeout
  endif

  _fnSetErr( iif( ft_int86( INT21, aRegs ), ESUCCESS, EINT86 ) )

  return UNSIGNED( lowbyte( aRegs[AX] ) )
