/*
 * File......: XPRTJOB.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "netto.ch"

#ifdef FT_TEST
   function main()
      local cJob

      create printjob cJob

      qout( len( cJob ) )
      return nil
#endif


/*  $DOC$
 *  $FUNCNAME$
 *     CREATE PRINTJOB
 *  $CATEGORY$
 *     Queue
 *  $ONELINER$
 *     Create a print job client record area
 *  $SYNTAX$
 *
 *     CREATE PRINTJOB <cPrtJob> ;
 *         [ VERSION      <nVersion>   ] ;
 *         [ TAB SIZE     <nTabSz>     ] ;
 *         [ COPIES       <nCopies>    ] ;
 *         [ TEXT|BINARY               ] ;
 *         [ NOBANNER                  ] ;
 *         [ NOFORMFEED                ] ;
 *         [ INTERRUPT                 ] ;
 *         [ MAXLINES     <nMaxLn>     ] ;
 *         [ MAXCHARS     <nMaxCh>     ] ;
 *         [ FORM NAME    <cForm>      ] ;
 *         [ BANNER NAME  <cBanNam>    ] ;
 *         [ BANNER FILE  <cBanFil>    ] ;
 *         [ HEADER FILE  <cHdrFil>    ] ;
 *         [ DIRPATH      <cDirPath>   ]
 *
 *  $ARGUMENTS$
 *
 *      VERSION <nVersion>
 *         A numeric indicating the version of the client record area.
 *         Currently NetWare expects 0.  Default is 0.
 *
 *      TAB SIZE <nTabSz>
 *         A numeric indicating the number of spaces to expand tabs to
 *         if the stream type is TEXT.  Default is 8.  Ignored if stream
 *         type is BINARY.
 *
 *      COPIES <nCopies>
 *         A numeric indicating number of copies to print.  Default is 1.
 *
 *      NOBANNER
 *         Specifies that a banner page is not to be printed.
 *
 *      TEXT | BINARY
 *         If TEXT is specified, then the data to be printed will be
 *         treated as a text stream, and the characters-per-line and
 *         lines-per-page and tab-size values will be honored. If
 *         BINARY is specified, then the data to be printed will be
 *         treated as a binary stream, and the characters-per-line and
 *         lines-per-page and tab-size values will be ignored.
 *         Default is TEXT.  If both BINARY and TEXT are selected,
 *         BINARY wins.
 *
 *      NOFORMFEED
 *
 *         Suppresses an automatic page eject at the end of the print job.
 *
 *      INTERRUPT
 *
 *         Instructs the Queue server to go ahead and print the job if it
 *         get interrupted during the capture process.
 *
 *      MAXLINES <nMaxLn>
 *
 *         The maximum lines per page, if printing in TEXT stream mode.
 *         Default is 60.
 *
 *      MAXCHARS <nMaxCh>
 *
 *         The maximum characters per line, if printing in TEXT stream
 *         mode.  Default is 132.
 *
 *      FORM NAME <cForm>
 *
 *         A 15 char string indicating the form name.  Different form
 *         types may be set up for each printer.  If a form type other than
 *         the current is specified, the print queue manager and any
 *         designated users will be notified to change forms.
 *
 *      BANNER NAME <cBanNam>
 *
 *         A 12 char string that is printed in large letters in the first
 *         box of the banner.  Novell typically defaults to the User Name
 *         but we just default to air.
 *
 *      BANNER FILE <cBanFil>
 *
 *         A 12 char string that is printed in large letters in the second
 *         box of the banner.  Novell defaults to the queue file name, we
 *         we don't default to nuthin.
 *
 *      HEADER FILE <cHdrFil>
 *
 *         The file name that is printed in the header of the banner.
 *         13 characters max.
 *
 *      DIRPATH <cDirPath>
 *
 *         The full path name of the file to be printed, up to 79 chars.
 *
 *  $RETURNS$
 *
 *      <cPrtJob>, a character string that can be used as the "client
 *      record area" for a regular Queue job destined to be serviced
 *      by a NetWare print server.  See CREATE JOBSTRUCT and the other
 *      QMS calls for further information.
 *
 *  $DESCRIPTION$
 *
 *      For printing to the NetWare Print Queue system, a job structure
 *      must be created that includes the above information in an entry
 *      called the Client Record Area.  This command lets you easily set
 *      the proper CRA for print queues.
 *
 *  $EXAMPLES$
 *
 *            /* get list of queues from default server */
 *
 *      aQueues := fn_scaBndO( "*", OT_PRINT_QUEUE )
 *
 *            /* select a queue, get Bindery Object ID for it */
 *
 *      nQueue := 7
 *
 *      nQueueID := aQueues[ nQueue, 2 ]
 *
 *            /* create Client Record Area for Netware print server */
 *
 *      CREATE PRINTJOB cPrtJob                          ;
 *         NOFORMFEED                                    ;
 *         BANNER NAME  fn_WhoAmI() 
 * 
 *            /* create queue job directed to any print server ( servicing
 *               the default file server ) */
 *
 *      CREATE JOBSTRUCT aJob                            ;
 *         JOB DESCRIPTION       "Weekly Test Results"   ;
 *         CLIENT RECORD AREA    cPrtJob
 * 
 *            /* create queue job file from newly created job structure */
 *
 *		  nHandle := fn_CrQJbFi( nQueueID, @aJob )
 *
 *            /* write to the queue job file */
 *
 *      FWRITE( nHandle, "This is a waste of paper" )
 *      FWRITE( nHandle, CHR( 12 ) )   // insert a formfeed in the file
 *
 *            /* start the queue job (file gets closed automatically ) */
 *
 *      nJob := aJob[ QJ_JOB_NUMBER ]
 *
 *      fn_stQJob( nQueueID, nJob, nHandle )
 *
 *  $SEEALSO$
 *     "CREATE JOBSTRUCT"
 *  $INCLUDE$
 *
 *  $END$
 */

function _fnprtjob( nVersion, nTabSz, nCopies, lNoBanner, ;
                    lTxtStr, lBinStr, lNFF, lInt, nMaxLn,        ;
                    nMaxCh, cForm, cBanNam, cBanFil,    ;
                    cHdrFil, cDirPath )
  local cFlags := chr( 0 ), nFlags

  default nVersion  to 0,;
          nTabSz    to 8,;
          nCopies   to 1,;
          lNoBanner to .f.,;
          lTxtStr   to .t.,;
          lBinStr   to .f.,;
          lNFF      to .f.,;
          lInt      to .t.,;
          nMaxLn    to 60,;
          nMaxCh    to 132,;
          cForm     to "",;
          cBanNam   to "",;
          cBanFil   to "",;
          cHdrFil   to "",;
          cDirPath  to ""


  lTxtStr := !lBinStr                            // Binary streams win

  cFlags   := iif( !lNoBanner, ft_bitset( cFlags, 7 ), cFlags ) // create control flag
  cFlags   := iif( lTxtStr   , ft_bitset( cFlags, 6 ), cFlags )
  cFlags   := iif( lNFF      , ft_bitset( cFlags, 3 ), cFlags )
  cFlags   := iif( lInt      , ft_bitset( cFlags, 2 ), cFlags )
  cFlags   := CHR(0) + cFlags

  cForm    := padr( subs( cForm,   1, 15 ),  16, CHR(0) )
  cBanNam  := padr( subs( cBanNam, 1, 12 ),  13, CHR(0) )
  cBanFil  := padr( subs( cBanFil, 1, 12 ),  13, CHR(0) )
  cHdrFil  := padr( subs( cHdrFil, 1, 13 ),  14, CHR(0) )
  cDirPath := padr( subs( cDirPath,1, 79 ),  80, CHR(0) )

  return I2BYTE( nVersion )      + ;
         I2BYTE( nTabSz   )      + ;
         W2HILO( nCopies  )      + ;
         cFlags                  + ;
         W2HILO(  nMaxLn   )     + ;
         W2HILO(  nMaxCh   )     + ;
                 cForm           + ;
         repl( chr(0), 6  )      + ;     // Reserved
                 cBanNam         + ;
                 cBanFil         + ;
                 cHdrFil         + ;                 
                 cDirPath
