/*
 * File......: SCURSTAT.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "netto.ch"


/*  $DOC$
 *  $FUNCNAME$
 *     FN_SQSTAT()
 *  $CATEGORY$
 *     Queue
 *  $ONELINER$
 *     Set queue current status
 *  $SYNTAX$
 *
 *     fn_sQStat( nQueueID [, <lJobAdd> ] [, <lAttach> ] [, <lService> ] )
 *           -> lSuccess
 *
 *  $ARGUMENTS$
 *
 *    <nQueueID> is the bindery object ID for the queue
 *    <lJobAdd>  is true if jobs can be added to the queue, .f. if they can't
 *    <lAttach>  is true if servers can attach to the queue, .f. if they can't
 *    <lService> is true if jobs can be serviced, .f. if they can't
 *
 *    All the flags ( <lJobAdd>, <lAttach>, <lService> ) default to .t.
 *
 *
 *  $RETURNS$
 *
 *    <lSuccess> - .t. if the call succeeded, .f. if it didn't (check
 *                 FN_ERROR().
 *
 *  $DESCRIPTION$
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

function fn_sQStat( nQueueID, lJobAdd, lAttach, lService )
   local cReq, cRep, cFlags := chr(0)

   default lJobAdd   to .t., ;
           lAttach   to .t., ;
           lService  to .t.

   if !lJobAdd
      cFlags := ft_bitset( cFlags, 0 )
   endif

   if !lAttach
      cFlags := ft_bitset( cFlags, 1 )
   endif

   if !lService
      cFlags := ft_bitset( cFlags, 2 )
   endif

   cReq := I2BYTE( 103 ) + L2HILO( nQueueID ) + cFlags
   cRep := ""

   return _fnReq( 227, cReq, @cRep ) == ESUCCESS
