/*
 * File......: RDQSTAT.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FN_RDQSTA()
 *  $CATEGORY$
 *     Queue
 *  $ONELINER$
 *     Read queue current status
 *  $SYNTAX$
 *
 *     fn_rdQSta( nQueueID ) -> aStatStruct
 *
 *  $ARGUMENTS$
 *
 *    <nQueueID> is the bindery object ID for the queue
 *
 *  $RETURNS$
 *
 *    <aStatStruct>, an array structured as follows:
 *
 *       Index                        Contents
 *       -----     ---------------------------------------------
 *
 *         1         Queue ID  (numeric) - the bindery object ID
 *                   of the Queue
 *         2         Job Add? (logical) - If false, the operator
 *                   has indicated no new jobs should be added to
 *                   the queue
 *         3         Server attach? (logical) - If false, the 
 *                   operator has indicated no additional job 
 *                   servers should attach to the queue
 *         4         Service jobs? (logical) - If false, the
 *                   operator has indicated no jobs should be 
 *                   serviced in the queue (like a hold).
 *         5         NumJobs (numeric) - the number of jobs 
 *                   currently in the queue
 *         6         NumServers (numeric) - the number of servers
 *                   currently attached that can service the queue
 *         7         Server ID List (array) - an array of 
 *                   bindery object IDs (numerics) of the servers
 *                   currently attached that can service the queue
 *         8         Sever Station List (array) - an array of 
 *                   station IDs (numerics) of the servers currently
 *                   attached that can service the queue
 *         9         MaxServers (numeric) - 
 *
 *
 *  $DESCRIPTION$
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

#include "netto.ch"

function fn_rdQSta( nQueueID )
   local cReq, cRep, aStat := {}, nX, nNumServ, aSid := {}, aSSta := {}, nOffset

   if pcount() == 1 .and. valtype( nQueueID ) == "N"

      cReq := I2BYTE( 102 ) + L2HILO( nQueueID )
      cRep := repl( chr(0), 133 )

      if _fnReq( 227, cReq, @cRep ) == ESUCCESS

         nNumServ := BYTE2I( subs( cRep, 7, 1 ) )        // Number of servers

         aStat := { HILO2L( subs( cRep, 1, 4 ) ),      ;      // Queue ID
                    ft_isbit( subs( cRep, 5, 1),  0 ), ;      // Job add?
                    ft_isbit( subs( cRep, 5, 1),  1 ), ;      // Server attach?
                    ft_isbit( subs( cRep, 5, 1),  2 ), ;      // Service jobs?
                    BYTE2I( subs( cRep, 6, 1 ) ),      ;      // Number of jobs
                    nNumServ,                          ;      // Number of servers
                    {},                                ;      // Server ID List
                    {},                                ;      // Server Stations List
                    BYTE2I( subs( cRep, len( cRep ) ) );      // Max servers
                  }


         if nNumServ > 0
            nOffSet := 8

            for nX := 1 to nNumServ
               aadd( aStat[7], HILO2L( subs( cRep, nOffset, 4 ) ) )
               nOffset += 4
            next

            for nX := 1 to nNumServ
               aadd( aStat[8], BYTE2I( subs( cRep, nOffset++, 1 ) ) )
            next

         endif

      endif

   else
      _fnSetErr( EBADPARM )
   endif

   return aStat

