/*
 * File......: ABORTSVC.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


#include "netto.ch"

/*  $DOC$
 *  $FUNCNAME$
 *     fn_abQJbFi()
 *  $CATEGORY$
 *     Queue
 *  $ONELINER$
 *     Abort servicing queue job and file 
 *  $SYNTAX$
 *
 *     fn_abQJbFi()( <nQueueID>, <nJob>, <nHandle> ) -> lSuccess
 *
 *  $ARGUMENTS$
 *
 *     <nQueueID> is the bindery object ID of the queue
 *     <nJob>     is the job number the server wants to abort
 *     <nHandle>  is the DOS file handle returned from fn_sQJobFi()
 *
 *  $RETURNS$
 *         
 *     <lSuccess>, .t. if the call succeeds.  If it doesn't, check 
 *     fn_error() for one of the following error codes:
 *
 *          150    =  Server out of memory
 *          208    =  Queue Error
 *          209    =  No queue
 *          214    =  No job rights
 *          217    =  Station is not a server
 *
 *  $DESCRIPTION$
 *
 *     This call is made by queue servers, and only if they have
 *     already obtained a job for servicing.
 *
 *     This closes the job file and deletes it from the job queue
 *     if the restart flag was not set.  If the restart flag was
 *     set, the job remains at the beginning of the queue.
 *
 *     You might not want to abort queue jobs just because the job
 *     was not submitted properly, unless you're sure the job will 
 *     be deleted from the queue.  Otherwise, it'll stay there and 
 *     the next time you try to service a job, you'll get the same
 *     one back.  If you want to finish a job and be sure it gets 
 *     deleted, use fn_finsqjb().
 *
 *  $EXAMPLES$
 *
 *     // This example assumes a lot has been set up.
 *     // Just pay attention to the abort logic.
 *
 *     local aJobStruct
 *
 *     aJobStruct := fn_sQJobFi( nID, -1, @nHandle )
 *     if !empty( aJobStruct )
 *        if fatalErr() // determine that server must fatal exit, so:
 *           fn_abqjbfi( nID, aJobStruct[ QJ_JOB_NUMBER ], nHandle )
 *           fatal() 
 *        else // finish normally
 *           fn_finsqjb( nID, aJobStruct[ QJ_JOB_NUMBER ], nHandle )
 *        endif
 *      endif
 *
 *
 *  $SEEALSO$
 *     fn_finsqjb()  fn_sqjbfi()
 *  $INCLUDE$
 *
 *  $END$
 */

function fn_abQJbFi( nQueueID, nJob, nHandle )
  local cReq, cRep, lRes := .f.


  if pcount() == 3 .and. ;
     valtype( nQueueID ) == "N" .and. ;
     valtype( nJob     ) == "N" .and. ;
     valtype( nHandle  ) == "N" 

     if ( nHandle # -1 ) 
        fclose( nHandle )
     endif

     cReq := I2BYTE( 115  ) + L2HILO( nQueueID ) + W2HILO( nJob )
     cRep := ""
     
     lRes := ( _fnReq( 227, cReq, @cRep ) == ESUCCESS )

  else
     _fnSetErr( EBADPARM )
  endif

  return lRes
