/*
 * File......: CAPTPJOB.PRG
 * Author....: Kevin Maher/Steve Tyrakowski
 * CIS ID....: 73766.1224
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Kevin Maher and Steve Tyrakowski
 * and is placed in the public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "ftint86.ch"
#include "netto.ch"

/*  $DOC$
 *  $FUNCNAME$
 *     fn_CapPJb()
 *  $CATEGORY$
 *     Print
 *  $ONELINER$
 *     Set Capture Print Job.
 *  $SYNTAX$
 *
 *     fn_CapPJb(nDevice, nJob, @cHandle) -> NIL
 *
 *  $ARGUMENTS$
 *
 *     <nDevice> 1, 2, 3 for LPT1,LPT2,LPT3
 *
 *     <nJob> The number (1 to 999) that a server's queue management
 *            system assigns to a print queue job entry in the queue
 *
 *     <@cHandle> A number that identifies the capture file associated
 *                with the print queue job entry (6 bytes). This must
 *                be passed by reference.
 *
 *
 *  $RETURNS$
 *
 *     NIL
 *
 *
 *  $DESCRIPTION$
 *
 *      This function assigns a print queue job number to a capture
 *      file and returns the netware file handle.
 *
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *  $END$
 */



FUNCTION fn_CapPJb(nDevice, nJob, cHandle)
LOCAL aRegs[INT86_MAX_REGS]

  aRegs[ AX ] := makeHI(176) + 7
  aRegs[ BX ] := nJob
  aRegs[ DX ] := makeHI((nDevice - 1))

  aRegs[ SI ] := Left(cHandle,2)
  aRegs[ DI ] := Substr(cHandle,3,2)
  aRegs[ CX ] := Right(cHandle,2)

  IF ft_int86( INT21, aRegs )
      _fnSetErr( UNSIGNED( lowbyte( aRegs[ AX ] ) ) )
  ELSE
      _fnSetErr( EINT86 )
  ENDIF

RETURN (NIL)
