/*
 * File......: VOLNAME.PRG
 * Author....: David A. Minter
 * CIS ID....: 76247,3475
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by David Minter and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include  "netto.ch"

/*  $DOC$
 *  $FUNCNAME$
 *     FN_VOLNAME()
 *  $CATEGORY$
 *     File System
 *  $ONELINER$
 *     Get the volume name given the volume number.
 *  $SYNTAX$
 *
 *	  fn_volName( <nVolumeNumber> ) -> <cVolName>
 *
 *  $ARGUMENTS$
 *
 *		 <nVolumeNumber> is a volume's offset into the volume table.
 *
 *  $RETURNS$
 *     
 *     <cVolName> is the name of the server volume, with no colon
 *                at the end. If <cVolName> is empty there was an
 *                error (check with fn_error())
 *
 *     Possible fn_error() returns:
 *
 *          152      Volume does not exist
 *
 *  $DESCRIPTION$
 *
 *		 This function determines a volume's name given its number.
 *
 *  $EXAMPLES$
 *
 *			function main( nVolNum )
 *				return qout( fn_volName( val( nVolNum ) ) )
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */


#ifdef FT_TEST

  function main( nVolNum )
     local cVol := fn_volName( val( nVolNum ) )
     return qout ( iif( empty( cVol ), "Volume does not exist", cVol ) )

#endif

function fn_volName( nVol )
  local cReq, cRep, cName := ""

  default nVol to 0

	cReq := I2BYTE( 6 ) + I2BYTE( nVol )
	cRep := space(17)

  if ( _fnReq( 226, cReq, @cRep ) == ESUCCESS )
     cName := substr( cRep, 2 )
  endif

  return alltrim( fn_noNull( cName ) )

