/*
 * File......: RESDH.PRG
 * Author....: Glenn Scott
 * CIS ID....: 71620,1521
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Glenn Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "netto.ch"

/*  $DOC$
 *  $FUNCNAME$
 *     FN_RESDH()
 *  $CATEGORY$
 *     File System
 *  $ONELINER$
 *     Restore directory handle
 *  $SYNTAX$
 *
 *     fn_resDH( <cSavBuff> ) -> { nHandle, nEffRights }
 *
 *  $ARGUMENTS$
 *
 *  $RETURNS$
 *
 *  $DESCRIPTION$
 *
 *  $EXAMPLES$
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */

function fn_resDH( cSavBuff ) 
  local cReq, cRep, aRes := {}

  if pcount() == 1 .and. valtype( cSavBuff ) == "C"
     
     cReq := I2BYTE( 24 ) + cSavBuff
     cRep := repl( chr(0), 2 )
     
     if _fnReq( 226, cReq, @cRep ) == ESUCCESS
        aRes := { BYTE2I( subs( cRep, 1, 1 ) ),;     // New directory handle
                  BYTE2I( subs( cRep, 2, 1 ) );      // Effective Rights Mask
                }
     endif

  else
     _fnSetErr( EBADPARM )
  endif

  return aRes
