/*
 * File......: GETPATH.PRG
 * Author....: Ted Means
 * CIS ID....: 73067,3332
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Ted Means and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "netto.CH"

/*  $DOC$
 *  $FUNCNAME$
 *     fn_GetPath()
 *  $CATEGORY$
 *     File System
 *  $ONELINER$
 *     Get a full directory path given a directory handle.
 *  $SYNTAX$
 *
 *     fn_GetPath( <nHandle> ) --> <cPathSpec>
 *
 *  $ARGUMENTS$
 *
 *    <nHandle> is a directory handle.
 *
 *  $RETURNS$
 *
 *    <cPathSpec> will be a path specification.  If the call fails then
 *                an empty string will be returned and fn_Error() should
 *                be used to determine the nature of the error.
 *
 *  $DESCRIPTION$
 *
 *    Use this function to query the handle table for directory information.
 *
 *  $EXAMPLES$
 *    // Obtain the path for handle 4
 *
 *       ? fn_GetPath( 4 )
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *    netto.CH (only needed if you want to make use of the #defines for
 *              the error codes).
 *  $END$
 */

function fn_GetPath( nHandle )
  local cReply := chr( 255 ) + space( 255 )
  local cPath

  _fnReq( 226, chr( 1 ) + chr( nHandle ), @cReply )

  cPath := substr( cReply, 2 )

  return iif( fn_Error() == 0, rtrim( cPath ), "" )


