/*
 *   File......: GDLFSO.Prg
 *   Author....: Sheldon Easterbrook
 *   CIS ID....: 71421,254
 *   Date......: $Date$
 *   Revision..: $Revision$
 *   Log File..: $LogFile$
 *
 *   This is an original work by Sheldon Easterbrook and is placed in the
 *   Public Domain
 *
 *   Modification History:
 *   ---------------------
 *
 *   $Log$
 *
 */

/*  $DOC$
 *  $FUNCNAME$
 *     Fn_GDLFSO()
 *  $CATEGORY$
 *     File System
 *  $ONELINER$
 *     Return a drive letter for a given search order
 *  $SYNTAX$
 *
 *      Fn_GDLFSO( <cPathVar>,<nSearchOrder> ) -> <cDrvLtr>
 *
 *  $ARGUMENTS$
 *
 *      <cPathVar> - Current DOS path variable.
 *
 *      <nSearchOrder> - The search order to look for.
 *
 *  $RETURNS$
 *
 *     <cDrvLtr> - This is the drive letter in position
 *                 <nSearchOrder>.
 *
 *  $DESCRIPTION$
 *
 *      This function returns the drive letter found at position
 *      <nSearchOrder> in <cPathVar>.
 *
 *  $EXAMPLES$
 *
 *      cDrive := Fn_GDLFSO( GetEnv( "PATH" ),1 )
 *
 *  $SEEALSO$
 *      Fn_GSOFDL()
 *  $INCLUDE$
 *      
 *  $END$
 */


function fn_GDLFSO( cPathVar,nSrchOdr )
    Local cDrvLtr := ""

    cPathVar := _FndPVarE( cPathVar,nSrchOdr )
    If ( !Empty( cPathVar ))
        If ( SubStr( cPathVar,2,1 ) == ":" )
            cDrvLtr = SubStr( cPathVar,1,1 )
        EndIf
    EndIf
    return( cDrvLtr )

