/*
 * File......: CLRCONN.PRG
 * Author....: Rodgers Moore
 * CIS ID....: 75730,2244
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Rodgers Moore and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "netto.ch"

/*  $DOC$
 *  $FUNCNAME$
 *      FN_CLRCONN()
 *  $CATEGORY$
 *      File Server
 *  $ONELINER$
 *      [286] Clear logical connection on default file server
 *  $SYNTAX$
 *
 *      fn_ClrConn( [nConn] ) -> lSuccess
 *
 *  $ARGUMENTS$
 *
 *      <nConn> the logical connection number of the station to be cleared.
 *      If omitted defaults to the current station.
 *
 *  $RETURNS$
 *
 *      A logical value .T. for success and .F. for failure.
 *
 *  $DESCRIPTION$
 *
 *      This function implements the File Server API call Clear Connection.
 *
 *      THIS CALL WORKS ON NETWARE 286 ONLY.
 *     
 *  $EXAMPLES$
 *
 *      ? fn_Logged(5)      ==> .T.
 *      ? fn_ClrConn(5)     ==> .T.
 *      ? fn_Logged(5)      ==> .F.
 *
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *
 *  $END$
 */


function fn_ClrConn( nConn )
   local cReq, cRep 

   default nConn to fn_connnum()

   cReq := I2BYTE( 210 ) + I2BYTE( nConn )
   cRep := ""

   return ( _fnReq( 227, cReq, @cRep ) < 2 )

