/*
 * File......: LOGGED.PRG
 * Author....: Rodgers Moore
 * CIS ID....: 75730,2244
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Rodgers Moore and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

#include "netto.ch"

/*  $DOC$
 *  $FUNCNAME$
 *      FN_LOGGED()
 *  $CATEGORY$
 *      Connection/Workstation
 *  $ONELINER$
 *      Return login status of logical connection or user
 *  $SYNTAX$
 *
 *      fn_Logged( [ <nConn> | <cUserName> ] ) -> lLogged_In
 *
 *  $ARGUMENTS$
 *
 *      <nConn> a numeric logical connection number of a station.
 *        .or.
 *      <cUserName> a character user name of a user.
 *      If ommited defaults to the current station.
 *
 *  $RETURNS$
 *
 *      A logical value:  Logged in (.T.) or Logged out (.F.)
 *
 *  $DESCRIPTION$
 *
 *      This is a high-level wrapper of fn_conninf() and fn_objcnum()
 *      which determines whether a logical connection is in use, or if
 *      a user is logged in or not.
 *     
 *  $EXAMPLES$
 *
 *      qout( "Connection 5 is "+if(fn_logged(5),"","not ")+"in use." )
 *      qout( "Joe is "+if(fn_logged("JOE"),"","not ")+"logged in." )
 *
 *  $SEEALSO$
 *     fn_conninf() fn_objcnum()
 *  $INCLUDE$
 *
 *  $END$
 */

function fn_logged( xParm )
   default xParm to fn_connnum()
   if valtype(xParm) == 'N'
      return ( fn_conninf(xParm)[1] != 0 )
   else
      return(len(fn_objcnum(xParm)) > 0)
   endif

   return nil // just to avoid warnings
