/*
 * File......: CHGPASS.PRG
 * Author....: Kevin Maher/Steve Tyrakowski
 * CIS ID....: 73766,1224
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 *
 * This is an original work by Kevin Maher and Steve Tyrakowski
 * and is placed in the public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FN_cBndOPw()
 *  $CATEGORY$
 *     Bindery
 *  $ONELINER$
 *     Change Bindery Object Password
 *  $SYNTAX$
 *
 *     FN_cBndOPw(cObject, nType, cOldPassWord, cNewPassWord) => lChanged
 *
 *  $ARGUMENTS$
 *
 *     <cObject> is the name of the Bindery Object to which you want to
 *		 change the password.  Max Length = 47
 *
 *     <nType> is the Bindery Object Type.  Manifest constants
 *	       describing the defined types are included in the NETTO.CH
 *	       header file.
 *
 *     <cOldPassWord> string containing the current password to be
 *		      checked for validity. Can be a maximun of 126
 *		      characters, must be in upper case, Null = no password.
 *
 *     <cNewPassWord> string containing the new password for the bindery
 *		      object.  Can be a maximun of 126 characters, must
 *		      be in upper case, Null = no password.
 *
 *  $RETURNS$
 *
 *     <lChanged> is a logical whether succesfull.  If an error
 *	    occurs this function will return .F..
 *
 *  $DESCRIPTION$
 *
 *     This function changes the password of a bindery object.
 *
 *     NOTE!  This function does _not_ support encrypted passwords.
 *     Due to licensing restrictions from Novell, we could not include
 *     encrypted support in this public domain release.  However, it
 *     is available.  See elsewhere in the Norton Guide for details
 *     on password encryption support.
 *
 *  $EXAMPLES$
 *
 *     lChanged :=  FN_cBndOPw("KEVIN",OT_USER,"123EWR","JT56CD")
 *
 *  $END$
 */

#include "ftint86.ch"
#include "netto.ch"

#define NW_LOG 227
#xcommand DEFAULT <v1> TO <x1> [, <vN> TO <xN> ];
      => IIF((<v1>)=NIL,<v1>:=<x1>,NIL) [; IF((<vN>)=NIL,<vN>:=<xN>,NIL)]

#ifdef FT_TEST
  FUNCTION MAIN(cObject, nType, cOld, cNew)
    default cobject to "KEVIN"
    default ntype to "1"
    default cold to ""
    default cnew to ""
    IF FN_cBndOPw(cObject,Val(nType),cOld,cNew)
      Qout("Password has been successfully changed")
    ELSE
      Qout("Password has not been successfully changed")
    ENDIF

  RETURN ( nil )

#endif

FUNCTION FN_cBndOPw(cObject, nType, cOldPassWord, cNewPassWord)

#ifdef NOENCRYPTION
  LOCAL cSend := I2BYTE(64);		       // 40h API Request Code
	       + W2HILO(nType); 	       // nw_int Object type
	       + fn_NameL(cObject,48);	       // Object Name
	       + fn_NameL(cOldPassWord,127);   // Old Password Length encoded
	       + fn_NameL(cNewPassWord,127)    // New Password Length encoded

RETURN (_fnReq(NW_LOG,cSend,"") == ESUCCESS)

#else

RETURN (_fnChgPW3(Upper(cObject), nType, Upper(cOldPassWord), Upper(cNewPassWord)) == ESUCCESS)

#endif

