/*
 * File......: ADDBIND.PRG
 * Author....: Kevin Maher/Steve Tyrakowski
 * CIS ID....: 73766,1224
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Kevin Maher and Steve Tyrakowski
 * and is placed in the public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FN_adBndO()
 *  $CATEGORY$
 *     Bindery
 *  $ONELINER$
 *     Add Bindery Object To Set
 *  $SYNTAX$
 *
 *     FN_adBndO(cOwnerName, nOwnerType, cProperty, cMemberName, nMemberType  )
 *	       => lAdded
 *
 *  $ARGUMENTS$
 *
 *     <cOwnerName> is the name of the Bindery Object that owns the SET
 *		    property to which you will add a member.
 *		    Max Length = 47
 *
 *     <nOwnerType> is the Object Type for <cOwnerName>.  Manifest constants
 *		    describing the defined types are included in the NETTO.CH
 *		    header file.
 *
 *     <cProperty> is the string containing the name of the <cOwnerName>'s
 *		   SET property.  Max Length = 15
 *
 *     <cMemberObject> Bindery Object Name that you will add to cProperty.
 *		       Max Length = 47
 *
 *     <nMemberType> is the Object Type for <cMemberName>.  Manifest
 *		     constants describing the defined types are included 
 *		     in the NETTO.CH header file.
 *
 *
 *  $RETURNS$
 *
 *     <lAdded> Logical if Object was successfully added.
 *
 *  $DESCRIPTION$
 *
 *     This function adds a bindery object to a property of type set.
 *     It returns true if successful or false if an error occured.
 *
 *  $SEEALSO$
 *    fn_wrProVa() fn_dBndOSe()
 *  $EXAMPLES$
 *
 *     // this will make user KEVIN a member of the development group.
 *     lAdded := FN_adBndO("KEVIN", OT_USER, "GROUPS_I'M_IN";
 *		    , "DEVELOPMENT", OT_USER_GROUP)
 *
 *  $END$
 */

#include "ftint86.ch"
#include "netto.ch"

#define NW_LOG 227

#ifdef FT_TEST
  FUNCTION MAIN(cOwnerName, nOwnerType, cProperty, cMemberObject, nMemberType  )
  LOCAL lAdded
    DEFAULT cOwnerName TO "TESTUSER"
    DEFAULT nOwnerType TO "1" // OT_USER
    DEFAULT cProperty  TO "GROUPS_I'M_IN"
    DEFAULT cMemberObject TO "TESTGROUP"
    DEFAULT nMemberType   TO "2" // OT_USER_GROUP

    lAdded := FN_adBndO(cOwnerName,Val(nOwnerType), cProperty, cMemberObject, Val(nMemberType))
    Qout(lAdded)
  RETURN ( nil )


#endif

FUNCTION FN_adBndO(cObject, nType, cProperty, cMemberObject, nMemberType)

  LOCAL cSend := I2BYTE(65);		           // 41h API Request Code
	       + W2HILO(nType); 	              // nw_int Object type
	       + fn_NameL(cObject,48);	        // Owner Name
	       + fn_NameL(Upper(cProperty),16);  // Property Name
	       + W2HILO(nMemberType);	           // nw_int Member Object type
	       + fn_NameL(cMemberObject,48)      // Member name to be added

  // See  crtprop.prg for Upper(cProperty) discussion

RETURN _fnReq(NW_LOG,cSend,"") == ESUCCESS
