//͸
//  Program .....: G_Net                                 
//  CopyRight ...: 1992 National Computer Consultants    
//                 All rights are reserved.              
//  Author ......: Greg Rice                             
//;

#include "error.ch"


FUNCTION fflock()

    WHILE ! flock()
      tell_mesg('File could not be locked ... Retry (Y/N)')

      IF upper(chr(lastkey())) == 'N'
        RETURN .f.

      END

      inkey(3)

    END

RETURN .t.


FUNCTION rrlock()

    WHILE ! rlock()
      tell_mesg('Record currently locked by another user ... Retry (Y/N)')

      IF upper(chr(lastkey())) == 'N'
        RETURN .f.

      END

      inkey(3)

    END

RETURN .t.


FUNCTION ffexcl( x )

    WHILE .t.

      use ( x ) exclusive

      IF ! neterr()
        exit

      END

      tell_mesg('Could not get exclusive rights ... Retry (Y/N)')

      IF upper(chr(lastkey())) == 'N'
        RETURN .f.

      END

      inkey(3)

    END

RETURN .t.


FUNCTION ffshare( x )

    local objError, lRetVal := .t.


    BEGIN SEQUENCE
      WHILE .t.
        use ( x ) shared

        IF ! neterr()
          exit

        END

        tell_mesg('Cannot open file in shared mode ... Retry (Y/N)')

        IF upper(chr(lastkey())) == 'N'
          lRetVal := .f.
          exit

        END

        inkey(3)

      END

    RECOVER USING objError
      if objError:genCode == EG_CORRUPTION
        lRetVal := .f.
      endif

    END SEQUENCE

Return( lRetVal )


FUNCTION ffadd()

    WHILE .t.
      appe blank

      IF ! neterr()
        exit

      END

      tell_mesg('Could not add record ... Retry (Y/N)')

      IF upper(chr(lastkey())) == 'N'
        RETURN .F.

      END

      inkey(3)
    END

Return( .t. )


STATIC FUNCTION tell_mesg(x)

    LOCAL y, x_buf := savescreen(3,10,6,69)

    keyboard ''
    y := setcolor()
    setcolor(popup_color())
    WinBox(3,10,5,67,0,4,.t.)
    NccMesg(x,4,'center,10,67',,0)
    restscreen(3,10,6,69,x_buf)
    setcolor(y)

RETURN NIL
