//͸
//  Program .....: G_Menu                                
//  CopyRight ...: 1992 National Computer Consultants    
//                 All rights are reserved.              
//  Author ......: Greg Rice                             
//;


#include "g_menu.ch"
#include "inkey.ch"

Function g_menu()

    local Bar


    Bar := NccBar():New(1)

    Bar:MouseActive := .t.

    Bar:AddMenuPrompt( ABOUT , '  '        ) ; Bar:PromptSubMenu( ABOUT ,  Menu_(0, Bar) )
    Bar:AddMenuPrompt( FILE , ' File '     ) ; Bar:PromptSubMenu( FILE ,  Menu_(1, Bar) )
    Bar:AddMenuPrompt( INDEX , ' Index '    ) ; Bar:PromptSubMenu( INDEX ,  Menu_(2, Bar) )
    Bar:AddMenuPrompt( VIEW , ' Fi~elds '   ) ; Bar:PromptSubMenu( VIEW ,  Menu_(3, Bar) )
    Bar:AddMenuPrompt( POSITION , ' Record ' ) ; Bar:PromptSubMenu( POSITION ,  Menu_(5, Bar) )
    Bar:AddMenuPrompt( WINDOW , ' Window '   ) ; Bar:PromptSubMenu( WINDOW ,  Menu_(6, Bar) )
    Bar:AddMenuPrompt( HELP , ' Help '     ) ; Bar:PromptSubMenu( HELP ,  Menu_(8, Bar) )

    Bar:PromptQuickKey( CHANGE_RECORD , K_ENTER )
    Bar:PromptQuickKey( VIEW_MODIFY   , K_ALT_L )
    Bar:PromptQuickKey( WIN_MOVE      , K_ALT_M )
    Bar:PromptQuickKey( SYS_EXIT      , K_ALT_X )
    Bar:PromptQuickKey( WIN_ZOOM      , K_ALT_Z )

    Bar:PromptQuickKey( INDEX_REORDER , K_CTRL_H )

Return( Bar )


static Function Menu_( x, Bar )

    local m, s


    m := NccMenu():New
    m:Shadow       := .t.
    m:Border       := 4
    m:LetterColor  := Bar:LetterColor

    Do Case
      Case x == 0
        m:AddPrompt( ABOUT_ABOUT , ' About ' )                                            ; m:PromptMessage( , 'About the NCC Demo' )

      Case x == 1
        m:AddPrompt( DATABASE_NEW     , ' New...', .f. )                           ; m:PromptMessage( , 'Create a New Database File'  )
        m:AddPrompt( DATABASE_OPEN    , ' Open...                F' )              ; m:PromptMessage( , 'Open a Database File' )
        m:AddPrompt( DATABASE_CLOSE   , ' Close' )                                 ; m:PromptMessage( , 'Close Database File' )
        m:AddPromptLine()


        m:AddPrompt( SYS_EXIT, ' e~Xit               Alt-X' ) ; m:PromptMessage( , 'Quit NCC Demo...' )

      Case x == 2
        m:AddPrompt( INDEX_OPEN     , ' Open...                           I' )     ; m:PromptMessage( , 'Open a Existing Index' )
        m:AddPrompt( INDEX_CLOSE    , ' Close...' )                                ; m:PromptMessage( , 'Close all Index files' )
        m:AddPromptLine()
        m:AddPrompt( INDEX_REORDER  , ' c~Hange index order...        Ctrl-H' )    ; m:PromptMessage( , 'Change Controlling Index order' )

      Case x == 3
        m:AddPrompt( VIEW_MODIFY  , ' modify field ~List...   Alt-L' )             ; m:PromptMessage( , 'Modify Fields in Window')
        m:AddPromptLine()
        m:AddPrompt( VIEW_VERT       , ' Vertical records' )                       ; m:PromptMessage( , 'Display records in a Vertical format' )
        m:AddPrompt( VIEW_HORI       , ' Horizontal records' )                     ; m:PromptMessage( , 'Display records in a Horizontal format' )


      Case x == 5
        m:AddPrompt( GO_REC          , ' Go to record...  G' )                     ; m:PromptMessage( , 'Go to specific record' )
        m:AddPrompt( LOCA_REC        , ' Locate...        L' )                     ; m:PromptMessage( , 'Locate a record based on a locate command' )
        m:AddPrompt( SEEK_REC        , ' Seek...          S' )                     ; m:PromptMessage( , 'Seek a record based on an Index condition' )

      Case x == 6
        m:AddPrompt( WIN_NEXT        , ' Next                Tab' )                ; m:PromptMessage( , 'Change to next window by mouse or keyboard' )
        m:AddPrompt( WIN_PREV        , ' Previous      Shift-Tab' )                ; m:PromptMessage( , 'Change to previous window by mouse or keyboard' )
        m:AddPrompt( WIN_MOVE        , ' Move/resize       Alt-M' )                ; m:PromptMessage( , 'Change window coordinates or position by mouse or keyboard' )
        m:AddPrompt( WIN_ZOOM        , ' Zoom              Alt-Z' )                ; m:PromptMessage( , 'Toggle between Full screen and default size window' )

      Case x == 8
        m:AddPrompt( HELP_GEN        , ' Help ' )                               ; m:PromptMessage( , 'Help on this Demo' )
        m:AddPrompt( HELP_WIN        , ' Window Help' )                                   ; m:PromptMessage( , 'Keys in the system' )

    EndCase

Return( m )
