/*

 Filename......: MyProg.Prg

 Author........: Vernon E. Six, Jr.

 Last Update...: Thu  02-04-1993  21:34:39

 Notice........: Copyright (c) 1993 by Vernon E. Six, Jr.
                 All Rights Reserved World Wide

                 All Forms Of Distribution Prohibited

 Dialect.......: Clipper v5.01

 Compile/Link..: clipper myprog /m /n /w /p /a
                 rtlink fi myprog lib demomakr

 Notes.........: Demonstrates DemoMakr.Lib

*/
 
                          
#include "demomakr.ch"

#xtranslate nTrim( <expN> ) => alltrim( str( <expN> ) )


function MyProg()
*****
* Example of how to use DemoMakr.Lib
*****

   clear screen

   ? dm_Version()
   ?
   ? "Copyright (c) 1993 by Vernon E. Six, Jr."
   ? "All Rights Reserved World Wide"
   ? ""
   ? "All Forms Of Distribution Prohibited"
   ?
   ?
   ?

   // Check the application's status
   //
   CheckIt()


   // Call your main program here
   //
   wait
   Phone()


return nil
*** eof: MyProg() *************************************************************




function CheckIt()
*****
* Check the status of the application
*****
local nStatus := 0
local cUser   := ""
local GetList := {}

   // Set the DemoMakr.Lib combination
   //
   dm_Combo( { 13, -205, 174, -112 } )


   // Read the status of the application
   //
   nStatus := dm_Init("MYPROG")


   do case                

      case nStatus = DM_FIRST

         // Make sure this is the first run
         //
         // ie: We know that PHONE.DBF is exactly 99 bytes when this
         //     application is first run, since we sent it with the
         //     application.  You should check the size or date of some
         //     known file.
         //
         if .not. (dm_FileSize("PHONE.DBF") == 99)

            dm_Tampered()  // Force all further executions to die even
                           // though DemoMakr.Lib thinks all is fine we know
                           // better.  ie: How else could PHONE.DBF have
                           // changed size?

            ? "Application Has Been Tampered With"
            dbCloseAll()
            quit
         endif


         // Force the application to die in 5 days
         //
         dm_SetDieDate( date()+5 )


         // or after four executions
         //
         dm_SetMaxRuns( 4 )



         ? "This is your first run"
         ? "This application will die in " + nTrim(dm_DaysLeft()) + " days"
         ? "This application will die in " + nTrim(dm_RunsLeft()) + " runs"

         cUser := space(15)
         @ 18,00 say "What is your name? " get cUser
         read

         dm_SetUser( 1, cUser )


      case nStatus = DM_NORMAL

         ? "This application will die in " + nTrim(dm_DaysLeft()) + " days"
         ? "This application will die in " + nTrim(dm_RunsLeft()) + " runs"
         ? "User Name: " + dm_GetUser(1)
      

      case nStatus = DM_REGISTERED

         ? "This is a registered application"


      case nStatus = DM_DIEDATE

         ? "Evalution period has been exceeded"
         dbCloseAll()
         quit


      case nStatus = DM_DIERUNS

         ? "Evaluation runs have been exceeded"
         dbCloseAll()
         quit


      case nStatus = DM_ROLLBACK

         ? "System Date has been rolled back!"
         dbCloseAll()
         quit
                                              

      case nStatus = DM_TAMPERED

         ? "Application Has Been Tampered With"
         dbCloseAll()
         quit
         

   endcase

return nil
*** eof: CheckIt() ************************************************************


function Phone()
*****
* A simple little example program
*****
local cName   := ""
local cPhone  := ""
local lAdding := .f.
local GetList := {}

   use phone alias phone new exclusive
   index on phone->name to phone

   while .t.

      cls

      cName  := space(30)
      cPhone := space(20)

      @ 01,00 say "This is a demonstration of DemoMakr.Lib"

      @ 05,00 say "Please type the name you want to lookup? " get cName
      @ 08,00 say "Enter an empty name to quit"
      read

      if empty(cName)
         exit
      endif

      if phone->( dbSeek(cName,.f.) )
         lAdding := .f.
         cPhone := phone->phone
         @ 08,00 say "Please type new phone number: " get cPhone
       else
         lAdding := .t.
         @ 08,00 say "What is his/her phone number? " get cPhone
      endif

      read

      if lAdding
         phone->( dbAppend() )
      endif

      phone->name  := cName
      phone->phone := cPhone

   enddo

   phone->( dbCloseArea() )

return nil
*** eof: Phone() **************************************************************






