//Ŀ
// Copyright (c) 1992 Delcom International Software Engineering           
//
//
//  Mouse.PRG
//
//  This file contains the remapped versions of SAVESCREEN/RESTSCREEN,
//  DISPBEGIN/DISPEND, and SCROLL which are mouse-sensitive.
//

#include "Mouse.ch"


***************************
**   FUNCTION M_SetMode  **
*****************************************************************************
//
//  This function is the mouse-sensitive version of SETMODE.
//

FUNCTION M_SetMode( nRows, nCols )

LOCAL nOldMouse := SetMouse( MOUSE_OFF ), lRetCode := .F.

ClearMouse()

lRetCode := SETMODE( nRows, nCols )

InitMouse()
SetMouse( nOldMouse )
SetMousePos( MAXROW() / 2, MAXCOL() / 2 )

RETURN lRetCode
//
// EOP: M_SetMode
//


******************************
**   FUNCTION M_SaveScreen  **
*****************************************************************************
//
//  This function is the mouse-sensitive version of SAVESCREEN.
//

FUNCTION M_SaveScreen( nTop, nLeft, nBottom, nRight )

LOCAL nOldMouse := SetMouse( MOUSE_OFF ), cScreen

nTop    := IF( nTop == NIL, 0, nTop )
nLeft   := IF( nLeft == NIL, 0, nLeft )
nBottom := IF( nBottom == NIL, MAXROW(), nBottom )
nRight  := IF( nRight == NIL, MAXCOL(), nRight )

cScreen := SAVESCREEN( nTop, nLeft, nBottom, nRight )

SetMouse( nOldMouse )

RETURN cScreen
//
// EOP: M_SaveScreen
//


******************************
**   FUNCTION M_RestScreen  **
*****************************************************************************
//
//  This function is the mouse-sensitive version of RESTSCREEN.
//

FUNCTION M_RestScreen( nTop, nLeft, nBottom, nRight, cScreen )

LOCAL nOldMouse := SetMouse( MOUSE_OFF )

RESTSCREEN( nTop, nLeft, nBottom, nRight, cScreen )

SetMouse( nOldMouse )

RETURN NIL
//
// EOP: M_RestScreen
//


************************
**   FUNCTION M_Disp  **
*****************************************************************************
//
//  This function is the mouse-sensitive version of DISPBEGIN/DISPEND.
//

FUNCTION M_Disp ( nMode )

STATIC nOldMouse

IF nMode == NIL
	RETURN NIL
ENDIF

IF nMode == 0
	nOldMouse := SetMouse( MOUSE_OFF )
	DISPBEGIN()
ELSE
	DISPEND()
	SetMouse( nOldMouse )

	nOldMouse := NIL
ENDIF

RETURN NIL
//
// EOP: M_Disp
//


**************************
**   FUNCTION M_Scroll  **
*****************************************************************************
//
//  This function is the mouse-sensitive version of SCROLL.
//

FUNCTION M_Scroll( nTop, nLeft, nBottom, nRight, nRows )

LOCAL nOldMouse := SetMouse( MOUSE_OFF )

SCROLL( nTop, nLeft, nBottom, nRight, nRows )

SetMouse( nOldMouse )

RETURN NIL
//
// EOP: M_Scroll
//
