
// CalcHard.prg - Complex demo of the calculator

#include "inkey.ch"

Function CalcHard()
Local getlist:={}, nInteger, nDontWork, nFloating, cText, nAnother

   Set Scoreboard OFF

   CLS

   CalcReg(00000)                  //insert your reg. no. here
   Set Key K_ALT_O to Calculator

   CalcInit("W+/R")                //try a Red Calculator

   //This will cause F2 to multiply anything by 2
   SetKey(K_F2,{|p,line,var,no| If(p="CALCULATOR", no * 2, NIL)})

   //This will cause F3 to do a square root
   SetKey(K_F3,{|p,line,var,no| If(p="CALCULATOR", Sqrt(no), NIL)})

   //This will cause the $ dollar sign to set fixed decimals to 2
   SetKey(Asc("$"),{|p|If(p="CALCULATOR", "F2", NIL)})

   //This will cause the calc to call CalcProc() when beginning and when
   // ending to display a personalized help screen.
   CalcUDF({|a,b,c,d,e,f,g,h|CalcProc(a,b,c,d,e,f,g,h)})

   nInteger :=7
   nDontWork:=6
   nAnother:=-5
   nFloating:=1.23
   cText    :=Space(8)

   @ 9,5 Get nInteger
   @10,5 Get nDontWork
   @11,5 Get nAnother
   @12,5 Get nFloating
   @13,5 Get cText

   @ 9,20 Say     "< The integer will transfer to the calculator."
   @10,20 Say     "< You can disable the calculator on specific fields."
   @11,20 Say     "< Negative."
   @12,20 Say     "< Floating Point transfer and return (Ctrl-Enter)."
   @13,20 Say     "< Text pasting. (press Ctrl-Enter inside calculator)."

   @15,5 Say "Press ALT-O to access the calculator"

   READ

Return NIL


Function CalcProc(cProc, nVer, cVar, nDisp, cDisp, nMode, cColor, nKey)
* cProc     = Procedure (always "CALCULATOR")
* nVer      = Version number (10 through 13, for ver 1.0 through ver 1.3)
* cVar      = Variable name of GET field called from
* nDisp     = Numeric display of calculator
* cDisp     = Character display of calculator
* cWhen     = Either "INIT" when beginning calc or "END" when leaving calc
* cColor    = Color when entering calculator
* nKey      = Lastkey pressed
*             * NOTE: Current color will always be "N/W", so use cColor
*             *       to determine color upon entry to calculator.
Static cSaveScreen
Local xRetVal

   If nMode = 0 //INIT: called going into the calculator

      //First, if this variable is "nDontWork," then abort (no calculator)
      If cVar = "NDONTWORK"
         Return .T.           // True = ABORT CALC
      Endif

      //Everything ok, change color to W+/B (if color display)
      // Also, NO need to SAVE COLOR, calculator does that.
      If(IsColor(),SetColor("W+/B"),NIL)

      //Everything ok, save screen, popup help screen
      cSaveScreen:=SaveScreen(0,29,7,51)
      @ 0,29 to 7,51 Double
      @ 1,30 Say " F2 = Display x 2    "
      @ 2,30 Say " F3 = Square Root    "
      @ 3,30 Say "  $ = Fix 2 decimals "
      @ 4,30 Say "  H = Calculator Help"
      @ 5,30 Say " F9 = Add Tax to val "
      @ 6,30 Say " F10= Put Tax in Mem "

      xRetVal := "F3" //fix decimals to 3 on INITIAL CALL

   Elseif nMode=3 //TERM: called going out of the calculator

      RestScreen(0,29,7,51,cSaveScreen)

   Elseif nMode=2 //Key Exception

      Do Case
         Case nKey = K_F9   //multiply TAX to current value
            xRetVal := nDisp * 1.0775

         Case nKey = K_F10  //stuff TAX into Memory!
            CalcMemory( 1.0775 )

      Endcase

   Endif

// (On INITIAL call from the calculator, if you return a character string,
//  it will be "keyboarded" into the calculator (remember Set Typeahead)).

Return xRetVal
