
/* Simple Demo of Calculator 1.5

   Compile using RT.BAT for RTLINK or
              BLINK.BAT for BLINKER

   Manually:
             Clipper DEMO /n/w

             Blinker fi DEMO lib CALC15
          or RTLink  fi DEMO lib CALC15

*/

#define F_BLOCKS  " "

#command CLS [with <char>] [color <color>]  ;
      => @ 0,0,MaxRow(),MaxCol() Box If(<.char.>,Repl(<char>,9),"         ") ;
         [Color <color>]


#include "inkey.ch"

Function Demo()
Local aColor, nVar1, nVar2, cVar1, GetList:={}


   CalcReg(00000)                  //insert your reg. no. here
   
   SET KEY K_F5 TO CALCULATOR


   //Set Environment
   Set Scoreboard OFF
   Set Confirm ON

   //Check Color
   If IsColor()
      aColor := {"W+/B,W/R,,,W/R","W/R","W/B,W/R,,,W/B"}
   Else
      aColor := {"W/N,N/W,,,W/N"}
   Endif

   //Setup Screen
   SetMode(25,80)
   SetColor(aColor[1])
   CLS with "" Color "W/N"
   @ 0,0,MaxRow(),52 Box F_BLOCKS

   //Setup Values
   nVar1 := 1
   nVar2 := 1.23

   cVar1 := Space(10)

   @ 9,2 Say "      Integer Test:"
   @ 9,22 Get nVar1 Color aColor[3]

   @10,2 Say "Fixed Decimal Test:"
   @10,22 Get nVar2 Color aColor[3]

   @12,2 Say "    Character Test:"
   @12,22 Get cVar1 Color aColor[3]

   SetColor(aColor[2])
   @ 1,2,7,50 Box F_BLOCKS
   @ 2,3 Say "Adding something as simple as:"
   @ 3,3 Say "SET KEY K_F5 TO CALCULATOR" Color "+"+SetColor()
   @ 4,3 Say "will allow all wait states access to "
   @ 5,3 Say "the Calculator() and will allow *all*"
   @ 6,3 Say "numerics and characters to receive the results:"

   @ 14,2,21,50 Box F_BLOCKS
   @15,3 Say "After you press F5, notice that it holds the"
   @16,3 Say "value of the variable.  After doing"
   @17,3 Say "calculations you can press CTRL-ENTER to paste"
   @18,3 Say "back the result."

   @20,3 Say "(Press H for Help in the Calculator)"

   SetColor(aColor[1])
   Read

   SetColor("W/N")
   Scroll(0,0,MaxRow(),MaxCol(),1)
   SetCursor(1)
   SetPos(MaxRow(),0)

Return NIL
