include qlib.inc
include string.inc
include stdio.inc
include conio.inc
include math.inc
include process.inc

.data
  yes db 80 dup (0)
  r1 real8 10.5
  r2 real8 0.5
  r3 real8 0.0
  r4 real8 10.0
.code
main proc
  call clrscr

  .if (!_fpu)
    callp printf,"FPU not detected!\n"
    callp exit,0
  .endif

  callp printf,"\n\tPrintf tests:\n\n"
  
  callp sprintf,offset yes,"Decimal tests:\n"
  callp print,offset yes
  callp printf,"(d)=%i\n",1234
  callp sprintf,offset yes,"(d)=%u\n",01234
  callp print,offset yes
  callp printf,"(d)=%d\n",-1234

  callp printf,"\nFloat tests:\n"
  callp printf,"%%f=%10.2f\n",r1
  callp printf,"%%f=%10.2f\n",r2
  callp printf,"%%f=%10.2f\n",r3
  callp printf,"%%f=%f\n",r3
  callp printf,"%%f=%10.0f\n",r4
  fldl2e  ;st = log2(e)
  fstp r4
  fwait
  callp printf,"%%f=%f\n",r4  ;1.44...
  callp atof,"10.4"
  .if _math_typ==1
    mov dptr[r4+4],eax    ;this is WATCOM style
    mov dptr[r4],edx
  .else
    fstp r4               ;this is Borland style (which I like better now)
    fwait
  .endif
  callp printf,"%%f=%f\n\n",r4
  callp printf,"(x)=%x\n",dptr[r4]           ;see what it looks like
  callp printf,"(x)=%x\n",dptr[r4+4]

  callp printf,"\nHex tests:\n"
  callp printf,"(x)=%x\n",12ab56cdh
  callp printf,"(X)=%X\n",12ab56cdh  

  callp printf,"Press a key...\n"
  callp getch

  callp printf,"\nBinary tests:\n"
  callp printf,"(b)=%05b\n",1
  callp printf,"(b)=%b\n",5678h  
  callp printf,"(b)=%b\n",155  

  callp printf,"\nOctal tests:\n"
  callp printf,"(o)=%o\n",5678h  
  callp printf,"(o)=%o\n",155  

  callp printf,"\nPrintf %s %s","totally","rulez\n"
  callp sprintf,offset yes,"It %s %s %i%s%i%s%i","Truely","does\n",1,"+",1,"=",2
  callp print,offset yes
  ret
main endp

end

