'******************************************************************************
'*            QBASIX - assembler routines for QBASIC - version 2              *
'*                      BASIC shell for using QBASIX                          *
'*                       (c) Hans Lunsing - 04/1993                           *
'******************************************************************************

'This file contains the BASIC shell which is necessary for using QBASIX
'in your own programs. The only things the shell does are checking if
'QBASIX is loaded and establishing its segment and offset. To save
'memory space the QBASIX routines are included in a separate file named
'QBASIX.PRO, from which you only need to copy the routines you really
'want to use. Don't forget to copy the routines which are called by them
'and the declarations going with them also.

'It is possible to use QBASIX with QuickBasic versions 4.0 and 4.5.
'In that case load the program with QB QBASIX /L QBABS.

'When you use this file as a start for your program you can of course
'remove this comment.

DEFINT A-Z

' Numbers of the assembler routines in QBasix:

CONST cBlinkStatus = 0
CONST cFillWindow = 1
CONST cGetActiveColor = 2
CONST cGetVideoInfo = 3
CONST cMsDOS = 4
CONST cInterruptX = 5
CONST cLptReady = 6
CONST cMemCopy = 7
CONST cMemScan = 8
CONST cSaveWindow = 9
CONST cRestoreWindow = 10
CONST cSetError = 11
CONST cShift = 12
CONST cToggleBlinkBit = 13
CONST cCmd = 14
CONST cSetCmd = 15

' Logical constants:

CONST TRUE = -1, FALSE = 0

' Declarations of procedures

DECLARE FUNCTION IsQBasix ()
DECLARE SUB PrintError (ErrCode)

'*****************************************************************************

' Room for more declarations

'*****************************************************************************

IF NOT IsQBasix THEN
  PrintError 110
  PRINT
  PRINT "---> Unfortunately, the program has to be stopped."
ELSE

'*****************************************************************************

' Room for the program

'*****************************************************************************

END IF
'*****************************************************************************
' When your program once is running well the END command can be replaced
' by SYSTEM. In that case QBASIC returns to DOS immediately after the
' program ends.
'*****************************************************************************
END

'*****************************************************************************

' Room for more subroutines and functions.

'*****************************************************************************

FUNCTION IsQBasix ()
  '***
  '*** Assembler routine to ascertain that QBasix is loaded and to get
  '*** its segment and offset:
  CONST IsQBasixASM = "U3ɸ/<u^^]"
  '*** N.B.: Do not change this constant !!!
  '***
  SHARED SegBasix, OffsBasix
  Temp$ = IsQBasixASM + CHR$(0)
  DEF SEG = VARSEG(Temp$)
  CALL ABSOLUTE(SegBasix, OffsBasix, SADD(Temp$))
  IsQBasix = (SegBasix <> 0)
END FUNCTION

SUB PrintError (ErrCode)
  'You can extend this routine with more error messages
  SELECT CASE ErrCode
    CASE 110
       PRINT "QBASIX is not loaded."
       PRINT "QBASIX has to be loaded before QBASIC by giving the command"
       PRINT "QBASIX or - in DOS 5 and higher only - QBASIX /H."
  END SELECT
END SUB

